/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

public final class MutableDouble
extends Number
implements Comparable {
    private double d;
    private static final long serialVersionUID = 624465615824626762L;

    public void set(double d) {
        this.d = d;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.d);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableDouble) {
            return this.d == ((MutableDouble)obj).d;
        }
        return false;
    }

    public String toString() {
        return Double.toString(this.d);
    }

    public int compareTo(MutableDouble anotherMutableDouble) {
        double thisVal = this.d;
        double anotherVal = anotherMutableDouble.d;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public int compareTo(Object o) {
        return this.compareTo((MutableDouble)o);
    }

    public int intValue() {
        return (int)this.d;
    }

    public long longValue() {
        return (long)this.d;
    }

    public short shortValue() {
        return (short)this.d;
    }

    public byte byteValue() {
        return (byte)this.d;
    }

    public float floatValue() {
        return (float)this.d;
    }

    public double doubleValue() {
        return this.d;
    }

    public MutableDouble() {
        this(0.0);
    }

    public MutableDouble(double d) {
        this.d = d;
    }

    public double increment(double inc) {
        this.d += inc;
        return this.d;
    }
}

