/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.IOUtils;
import edu.berkeley.nlp.util.LogInfo;
import edu.berkeley.nlp.util.MapUtils;
import edu.berkeley.nlp.util.StrUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<S, T> {
    private ArrayList<S> keys = new ArrayList();
    private Map<S, T> map = new HashMap<S, T>();

    public OrderedMap() {
    }

    public OrderedMap(OrderedMap<S, T> map) {
        for (S key : map.keys()) {
            this.put(key, map.get(key));
        }
    }

    public void clear() {
        this.keys.clear();
        this.map.clear();
    }

    public void log(String title) {
        LogInfo.track((Object)title, true);
        for (S key : this.keys()) {
            LogInfo.logs(key + "\t" + this.get(key));
        }
        LogInfo.end_track();
    }

    public void put(S key) {
        this.put(key, null);
    }

    public void putAtEnd(S key) {
        this.put(key, this.get(key));
    }

    public void removeAt(int i) {
        S key = this.keys.get(i);
        this.keys.remove(i);
        this.map.remove(key);
    }

    public void reput(S key, T val) {
        if (!this.map.containsKey(key)) {
            this.put(key, val);
        } else {
            this.map.put(key, val);
        }
    }

    public void put(S key, T val) {
        if (this.map.containsKey(key)) {
            this.keys.remove(key);
        }
        this.keys.add(key);
        this.map.put(key, val);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean containsKey(S key) {
        return this.map.containsKey(key);
    }

    public T get(S key) {
        return this.map.get(key);
    }

    public T get(S key, T defaultVal) {
        return MapUtils.get(this.map, key, defaultVal);
    }

    public Set<S> keySet() {
        return this.map.keySet();
    }

    public List<S> keys() {
        return this.keys;
    }

    public ValueCollection values() {
        return new ValueCollection();
    }

    public void print(PrintWriter out) {
        for (S key : this.keys) {
            this.print(out, key, this.map.get(key));
        }
        out.flush();
    }

    public void print(String path) throws IOException {
        this.print(new File(path));
    }

    public void printHard(String path) {
        PrintWriter out = IOUtils.openOutHard(path);
        this.print(out);
        out.close();
    }

    public void print(File path) throws IOException {
        PrintWriter out = IOUtils.openOut(path);
        this.print(out);
        out.close();
    }

    public String print() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw));
        return sw.toString();
    }

    void print(PrintWriter out, S key, T val) {
        out.println(key + (val == null ? "" : "\t" + val));
    }

    public boolean printEasy(String path) {
        if (StrUtils.isEmpty(path)) {
            return false;
        }
        return this.printEasy(new File(path));
    }

    public boolean printEasy(File path) {
        if (path == null) {
            return false;
        }
        try {
            PrintWriter out = IOUtils.openOut(path);
            this.print(out);
            out.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (S key : this.keys) {
            sb.append(key + " " + this.map.get(key) + "\n");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueCollection
    extends AbstractCollection<T> {
        @Override
        public Iterator<T> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<T> {
        private int next = 0;

        @Override
        public boolean hasNext() {
            return this.next < OrderedMap.this.size();
        }

        @Override
        public T next() {
            return OrderedMap.this.map.get(OrderedMap.this.keys.get(this.next++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

