/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static List<Class> getClassesForPackage(String pckgname) {
        String className;
        ArrayList<Class> classes = new ArrayList<Class>();
        ArrayList<File> directories = new ArrayList<File>();
        char fileSep = System.getProperty("file.separator").charAt(0);
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', fileSep));
            while (resources.hasMoreElements()) {
                URL res = resources.nextElement();
                if (res.getProtocol().equalsIgnoreCase("jar")) {
                    JarURLConnection conn = (JarURLConnection)res.openConnection();
                    JarFile jar = conn.getJarFile();
                    for (JarEntry e : Collections.list(jar.entries())) {
                        if (!e.getName().startsWith(pckgname.replace('.', fileSep)) || !e.getName().endsWith(".class") || e.getName().contains("$")) continue;
                        className = e.getName().replace("" + fileSep, ".").substring(0, e.getName().length() - 6);
                        classes.add(Class.forName(className));
                    }
                    continue;
                }
                directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (File directory : directories) {
            if (!directory.exists()) continue;
            String[] files = directory.list();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.endsWith(".class")) {
                    className = file.substring(0, file.length() - 6);
                    try {
                        classes.add(Class.forName(String.valueOf(pckgname) + '.' + className));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return classes;
    }

    public static List<Class> getClassessOfInterface(String thePackage, Class theInterface) {
        ArrayList<Class> classList = new ArrayList<Class>();
        try {
            for (Class discovered : ReflectionUtils.getClassesForPackage(thePackage)) {
                if (!Arrays.asList(discovered.getInterfaces()).contains(theInterface)) continue;
                classList.add(discovered);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classList;
    }
}

