/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.SloppyMath;
import java.util.Arrays;

public class ScalingTools {
    public static final int LOGSCALE = 100;
    public static final double SCALE = Math.exp(100.0);

    public static double calcScaleFactor(double logScale) {
        return ScalingTools.calcScaleFactor(logScale, SCALE);
    }

    public static double calcScaleFactor(double logScale, double scale) {
        if (logScale == -2.147483648E9) {
            return 0.0;
        }
        if (logScale == 0.0) {
            return 1.0;
        }
        if (logScale == 1.0) {
            return scale;
        }
        if (logScale == 2.0) {
            return scale * scale;
        }
        if (logScale == 3.0) {
            return scale * scale * scale;
        }
        if (logScale == -1.0) {
            return 1.0 / scale;
        }
        if (logScale == -2.0) {
            return 1.0 / scale / scale;
        }
        if (logScale == -3.0) {
            return 1.0 / scale / scale / scale;
        }
        return Math.pow(scale, logScale);
    }

    /*
     * Unable to fully structure code
     */
    public static int scaleArray(double[] scores, int previousScale) {
        if (previousScale == -2147483648) {
            return previousScale;
        }
        logScale = 0;
        scale = 1.0;
        max = DoubleArrays.max(scores);
        if (max == Infinity) {
            return 0;
        }
        if (max != 0.0) ** GOTO lbl13
        return previousScale;
lbl-1000:
        // 1 sources

        {
            max /= ScalingTools.SCALE;
            scale *= ScalingTools.SCALE;
            ++logScale;
lbl13:
            // 2 sources

            ** while (max > ScalingTools.SCALE)
        }
lbl14:
        // 2 sources

        while (max > 0.0 && max < 1.0 / ScalingTools.SCALE) {
            max *= ScalingTools.SCALE;
            scale /= ScalingTools.SCALE;
            --logScale;
        }
        if (logScale != 0) {
            i = 0;
            while (i < scores.length) {
                v0 = i++;
                scores[v0] = scores[v0] / scale;
            }
        }
        return previousScale + logScale;
    }

    public static void scaleArrayToScale(double[] scores, int previousScale, int newScale) {
        int scaleDiff = previousScale - newScale;
        if (scaleDiff == 0) {
            return;
        }
        double max = DoubleArrays.max(scores);
        if (SloppyMath.isDangerous(max)) {
            return;
        }
        double scale = ScalingTools.calcScaleFactor(scaleDiff);
        if (Math.abs(scaleDiff) >= 800) {
            Arrays.fill(scores, 0.0);
            return;
        }
        int i = 0;
        while (i < scores.length) {
            int n = i++;
            scores[n] = scores[n] * scale;
        }
    }

    public static double scaleToScale(double score, int previousScale, int newScale) {
        int scaleDiff = previousScale - newScale;
        if (scaleDiff == 0) {
            return score;
        }
        double max = score;
        if (SloppyMath.isDangerous(max)) {
            return 0.0;
        }
        double scale = ScalingTools.calcScaleFactor(scaleDiff);
        if (Math.abs(scaleDiff) >= 800) {
            return 0.0;
        }
        return score *= scale;
    }

    public static boolean isBadScale(int scale) {
        return scale == Integer.MIN_VALUE || scale == Integer.MAX_VALUE || scale == 0x7FFFFFFE || scale == -2147483647 || scale == 0x7FFFFFFD || scale == -2147483646;
    }
}

