/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.IdentityHashSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemUtils {
    public static long countApproximateMemoryUsage(Object ... o) {
        try {
            IdentityHashSet<Object> identityHashSet = new IdentityHashSet<Object>();
            long sum = 0L;
            Object[] objectArray = o;
            int n = o.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                sum += SystemUtils.countApproximateMemoryUsage(obj, identityHashSet);
                ++n2;
            }
            return sum;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static long countApproximateMemoryUsage(Object o, IdentityHashSet<Object> identityHashSet) throws IllegalArgumentException, IllegalAccessException {
        if (o == null || identityHashSet.contains(o)) {
            return 0L;
        }
        identityHashSet.add(o);
        Class<?> thisType = o.getClass();
        long sum = 8L;
        if (thisType.isArray()) {
            if (thisType == byte[].class) {
                sum += (long)(1 * ((byte[])o).length);
            } else if (thisType == boolean[].class) {
                sum += (long)(1 * ((boolean[])o).length);
            } else if (thisType == short[].class) {
                sum += (long)(2 * ((short[])o).length);
            } else if (thisType == char[].class) {
                sum += (long)(2 * ((char[])o).length);
            } else if (thisType == int[].class) {
                sum += (long)(4 * ((int[])o).length);
            } else if (thisType == double[].class) {
                sum += (long)(8 * ((double[])o).length);
            } else if (thisType == long[].class) {
                sum += (long)(8 * ((long[])o).length);
            } else if (thisType == float[].class) {
                sum += (long)(4 * ((float[])o).length);
            } else {
                Object[] objectArray = (Object[])o;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o2 = objectArray[n2];
                    sum += SystemUtils.countApproximateMemoryUsage(o2, identityHashSet);
                    ++n2;
                }
            }
        }
        long fieldSum = 0L;
        ArrayList list = new ArrayList();
        Class<?> c = o.getClass();
        list.add(c);
        while (c.getSuperclass() != null) {
            c = c.getSuperclass();
            list.add(c);
        }
        for (Class clazz : list) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n3 = 0;
            while (n3 < n) {
                Field field = fieldArray[n3];
                if (!Modifier.isStatic(field.getModifiers())) {
                    Class<?> type = field.getType();
                    field.setAccessible(true);
                    if (type.isPrimitive()) {
                        fieldSum = type == Long.TYPE || type == Double.TYPE ? (fieldSum += 8L) : (fieldSum += 4L);
                    } else {
                        fieldSum += 4L;
                        if (!field.isSynthetic() && !field.isAnnotationPresent(SkipMemoryCount.class)) {
                            Object object = field.get(o);
                            if (Thread.currentThread().getStackTrace().length > 50) {
                                throw new OutOfMemoryError("measuring memory usage used too much stack");
                            }
                            sum += SystemUtils.countApproximateMemoryUsage(object, identityHashSet);
                        }
                    }
                }
                ++n3;
            }
        }
        if (fieldSum % 8L != 0L) {
            fieldSum += 4L;
        }
        return sum + fieldSum;
    }

    public static void main(String[] argv) {
        Object testObject = new Object(){
            short[] x = new short[100];
            String[] y = new String[]{"xx", "yy"};
        };
        Object testObject2 = new Object(testObject){
            Object o;
            {
                this.o = object;
            }
        };
        System.out.println(SystemUtils.countApproximateMemoryUsage(testObject, testObject2));
        System.out.println(SystemUtils.countApproximateMemoryUsage(new Integer(1)));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SkipMemoryCount {
    }
}

