/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.AbstractTMap;
import edu.berkeley.nlp.util.Exceptions;
import edu.berkeley.nlp.util.LogInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatMap<T>
extends AbstractTMap<T>
implements Iterable<Entry>,
Serializable {
    protected static final long serialVersionUID = 42L;
    private float[] values;

    public TFloatMap() {
        this(AbstractTMap.defaultFunctionality, 2);
    }

    public TFloatMap(AbstractTMap.Functionality<T> keyFunc) {
        this(keyFunc, 2);
    }

    public TFloatMap(int expectedSize) {
        this(AbstractTMap.defaultFunctionality, expectedSize);
    }

    public TFloatMap(AbstractTMap<T> map) {
        this(map.keyFunc);
        this.mapType = map.mapType;
        this.locked = map.locked;
        this.num = map.num;
        this.keys = map.locked ? map.keys : (Object[])map.keys.clone();
        this.values = map instanceof TFloatMap ? (float[])((TFloatMap)map).values.clone() : new float[this.keys.length];
    }

    public TFloatMap(AbstractTMap.Functionality<T> keyFunc, int expectedSize) {
        this.keyFunc = keyFunc;
        this.mapType = AbstractTMap.MapType.HASH_TABLE;
        this.locked = false;
        this.num = 0;
        this.allocate(this.getCapacity(this.num, false));
        this.numCollisions = 0;
    }

    public boolean containsKey(T key) {
        return this.find(key, false) != -1;
    }

    public float get(T key, float defaultValue) {
        int i = this.find(key, false);
        return i == -1 ? defaultValue : this.values[i];
    }

    public float getWithErrorMsg(T key, float defaultValue) {
        int i = this.find(key, false);
        if (i == -1) {
            LogInfo.errors("%s not in map, using %f", key, Float.valueOf(defaultValue));
        }
        return i == -1 ? defaultValue : this.values[i];
    }

    public float getSure(T key) {
        int i = this.find(key, false);
        if (i == -1) {
            throw new RuntimeException("Missing key: " + key);
        }
        return this.values[i];
    }

    public void put(T key, float value) {
        assert (!Double.isNaN(value));
        int i = this.find(key, true);
        this.keys[i] = key;
        this.values[i] = value;
    }

    public void put(T key, float value, boolean keepHigher) {
        assert (!Double.isNaN(value));
        int i = this.find(key, true);
        this.keys[i] = key;
        if (keepHigher && this.values[i] > value) {
            return;
        }
        this.values[i] = value;
    }

    public void incr(T key, float dValue) {
        int i = this.find(key, true);
        this.keys[i] = key;
        if (Double.isNaN(this.values[i])) {
            this.values[i] = dValue;
        } else {
            int n = i;
            this.values[n] = this.values[n] + dValue;
        }
    }

    public void scale(T key, float dValue) {
        int i = this.find(key, true);
        if (i == -1) {
            return;
        }
        int n = i;
        this.values[n] = this.values[n] * dValue;
    }

    public int size() {
        return this.num;
    }

    public int capacity() {
        return this.keys.length;
    }

    public void gut() {
        this.values = null;
    }

    public float sum() {
        float sum = 0.0f;
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null) {
                sum += this.values[i];
            }
            ++i;
        }
        return sum;
    }

    public void putAll(float value) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null) {
                this.values[i] = value;
            }
            ++i;
        }
    }

    public void incrAll(float dValue) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null) {
                int n = i;
                this.values[n] = this.values[n] + dValue;
            }
            ++i;
        }
    }

    public void multAll(float dValue) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null) {
                int n = i;
                this.values[n] = this.values[n] * dValue;
            }
            ++i;
        }
    }

    public T argmax() {
        int besti = -1;
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null && (besti == -1 || this.values[i] > this.values[besti])) {
                besti = i;
            }
            ++i;
        }
        return (T)(besti == -1 ? null : this.keys[besti]);
    }

    public float max() {
        int besti = -1;
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null && (besti == -1 || this.values[i] > this.values[besti])) {
                besti = i;
            }
            ++i;
        }
        return besti == -1 ? Float.NEGATIVE_INFINITY : this.values[besti];
    }

    public void incrMap(TFloatMap<T> map, float factor) {
        int i = 0;
        while (i < map.keys.length) {
            if (map.keys[i] != null) {
                this.incr(map.keys[i], factor * map.values[i]);
            }
            ++i;
        }
    }

    public TFloatMap<T> copy() {
        TFloatMap<T> newMap = new TFloatMap<T>(this.keyFunc);
        newMap.mapType = this.mapType;
        newMap.locked = this.locked;
        newMap.num = this.num;
        newMap.keys = this.locked ? this.keys : (Object[])this.keys.clone();
        newMap.values = (float[])this.values.clone();
        return newMap;
    }

    public TFloatMap<T> restrict(Set<T> set) {
        TFloatMap<Object> newMap = new TFloatMap<Object>(this.keyFunc);
        newMap.mapType = this.mapType;
        if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
            this.allocate(this.getCapacity(this.num, false));
            int i = 0;
            while (i < this.keys.length) {
                if (set.contains(this.keys[i])) {
                    newMap.keys[newMap.num] = this.keys[i];
                    newMap.values[newMap.num] = this.values[i];
                    ++newMap.num;
                }
                ++i;
            }
        } else if (this.mapType == AbstractTMap.MapType.HASH_TABLE) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] != null && set.contains(this.keys[i])) {
                    newMap.put(this.keys[i], this.values[i]);
                }
                ++i;
            }
        }
        newMap.locked = this.locked;
        return newMap;
    }

    public EntryValueComparator entryValueComparator() {
        return new EntryValueComparator();
    }

    public void lock() {
        this.locked = true;
    }

    public void switchToSortedList() {
        this.switchMapType(AbstractTMap.MapType.SORTED_LIST);
    }

    public void switchToHashTable() {
        this.switchMapType(AbstractTMap.MapType.HASH_TABLE);
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    public EntrySet entrySet() {
        return new EntrySet();
    }

    public KeySet keySet() {
        return new KeySet();
    }

    public ValueCollection values() {
        return new ValueCollection();
    }

    private int getCapacity(int n, boolean compact) {
        int capacity;
        if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
            capacity = compact ? n : n * 2;
        } else if (this.mapType == AbstractTMap.MapType.HASH_TABLE) {
            capacity = n * 2 + 2;
        } else {
            throw new RuntimeException("Internal bug");
        }
        return Math.max(capacity, 1);
    }

    private void switchMapType(AbstractTMap.MapType newMapType) {
        block7: {
            float[] oldValues;
            Object[] oldKeys;
            block6: {
                assert (!this.locked);
                oldKeys = this.keys;
                oldValues = this.values;
                this.mapType = newMapType;
                this.allocate(this.getCapacity(this.num, true));
                this.numCollisions = 0;
                if (newMapType != AbstractTMap.MapType.SORTED_LIST) break block6;
                ArrayList<FullEntry> entries = new ArrayList<FullEntry>(this.num);
                int i = 0;
                while (i < oldKeys.length) {
                    if (oldKeys[i] != null) {
                        entries.add(new FullEntry(oldKeys[i], oldValues[i]));
                    }
                    ++i;
                }
                Collections.sort(entries);
                i = 0;
                while (i < this.num) {
                    this.keys[i] = ((FullEntry)entries.get(i)).key;
                    this.values[i] = ((FullEntry)entries.get(i)).value;
                    ++i;
                }
                break block7;
            }
            if (this.mapType != AbstractTMap.MapType.HASH_TABLE) break block7;
            this.num = 0;
            int i = 0;
            while (i < oldKeys.length) {
                if (oldKeys[i] != null) {
                    this.put(oldKeys[i], oldValues[i]);
                }
                ++i;
            }
        }
    }

    private int binarySearch(T targetKey) {
        int targetHash = this.hash(targetKey);
        int l = 0;
        int u = this.num;
        while (l < u) {
            int m = l + u >> 1;
            int keyHash = this.hash(this.keys[m]);
            if (targetHash < keyHash || targetHash == keyHash && ((Comparable)targetKey).compareTo(this.keys[m]) <= 0) {
                u = m;
                continue;
            }
            l = m + 1;
        }
        return l;
    }

    private int hash(T x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        if ((h ^= h >>> 10) < 0) {
            h = -h;
        }
        return h;
    }

    /*
     * Unable to fully structure code
     */
    private int find(T key, boolean modify) {
        block12: {
            if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
                i = this.binarySearch(key);
                if (i < this.num && this.keys[i] != null && key.equals(this.keys[i])) {
                    return i;
                }
                if (modify) {
                    if (this.locked) {
                        throw new RuntimeException("Cannot make new entry for " + key + ", because map is locked");
                    }
                    if (this.num == this.capacity()) {
                        this.changeSortedListCapacity(this.getCapacity(this.num + 1, false));
                    }
                    j = this.num;
                    while (j > i) {
                        this.keys[j] = this.keys[j - 1];
                        this.values[j] = this.values[j - 1];
                        --j;
                    }
                    ++this.num;
                    this.values[i] = NaNf;
                    return i;
                }
                return -1;
            }
            if (this.mapType != AbstractTMap.MapType.HASH_TABLE) break block12;
            capacity = this.capacity();
            keyHash = this.hash(key);
            i = keyHash % capacity;
            if (i < 0) {
                i = -i;
            }
            if (!this.locked && modify && ((double)this.num > 0.75 * (double)capacity || capacity <= this.num + 1)) {
                this.switchMapType(AbstractTMap.MapType.HASH_TABLE);
                return this.find(key, modify);
            }
            if (this.num != capacity) ** GOTO lbl34
            throw new RuntimeException("Hash table is full: " + capacity);
lbl-1000:
            // 1 sources

            {
                ++this.numCollisions;
                if (++i != capacity) continue;
                i = 0;
lbl34:
                // 3 sources

                ** while (this.keys[i] != null && !this.keys[i].equals(key))
            }
lbl35:
            // 1 sources

            if (this.keys[i] != null) {
                if (!TFloatMap.$assertionsDisabled && !key.equals(this.keys[i])) {
                    throw new AssertionError();
                }
                return i;
            }
            if (modify) {
                ++this.num;
                this.values[i] = NaNf;
                return i;
            }
            return -1;
        }
        throw new RuntimeException("Internal bug: " + (Object)this.mapType);
    }

    private void allocate(int n) {
        this.keys = this.keyFunc.createArray(n);
        this.values = new float[n];
    }

    private void changeSortedListCapacity(int newCapacity) {
        assert (this.mapType == AbstractTMap.MapType.SORTED_LIST);
        assert (newCapacity >= this.num);
        Object[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.allocate(newCapacity);
        System.arraycopy(oldKeys, 0, this.keys, 0, this.num);
        System.arraycopy(oldValues, 0, this.values, 0, this.num);
    }

    private void repCheck() {
        assert (this.capacity() > 0);
        if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
            assert (this.num <= this.capacity());
            int i = 1;
            while (i < this.num) {
                int h1 = this.hash(this.keys[i - 1]);
                int h2 = this.hash(this.keys[i]);
                assert (h1 <= h2);
                if (h1 == h2) assert (((Comparable)this.keys[i - 1]).compareTo(this.keys[i]) < 0);
                ++i;
            }
        }
    }

    public void debugDump() {
        LogInfo.logsForce("--------------------");
        LogInfo.logsForce("mapType = " + (Object)((Object)this.mapType));
        LogInfo.logsForce("locked = " + this.locked);
        LogInfo.logsForce("size/capacity = " + this.size() + "/" + this.capacity());
        LogInfo.logsForce("numCollisions = " + this.numCollisions);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject((Object)this.mapType);
        out.writeInt(this.num);
        for (Entry e : this) {
            out.writeObject(e.getKey());
            out.writeDouble(e.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.mapType = (AbstractTMap.MapType)((Object)in.readObject());
        this.num = 0;
        this.locked = false;
        int n = in.readInt();
        this.allocate(this.getCapacity(n, true));
        int i = 0;
        while (i < n) {
            Object key = this.keyFunc.intern(in.readObject());
            float value = in.readFloat();
            if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
                this.keys[this.num] = key;
                this.values[this.num] = value;
                ++this.num;
            } else if (this.mapType == AbstractTMap.MapType.HASH_TABLE) {
                this.put(key, value);
            }
            ++i;
        }
    }

    public static <T> TFloatMap newMap(Object ... args) {
        if (args.length % 2 != 0) {
            throw Exceptions.bad;
        }
        TFloatMap<Object> map = new TFloatMap<Object>();
        int i = 0;
        while (i < args.length) {
            Object key = args[i];
            Object value = args[i + 1];
            if (value instanceof Integer) {
                value = Float.valueOf(((Integer)value).intValue());
            }
            map.put(args[i], ((Float)value).floatValue());
            i += 2;
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Entry entry : this.entrySet()) {
            sb.append(entry.getKey() + ":" + entry.getValue() + ", ");
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry {
        private final int i;

        private Entry(int i) {
            this.i = i;
        }

        public T getKey() {
            return TFloatMap.this.keys[this.i];
        }

        public float getValue() {
            return TFloatMap.this.values[this.i];
        }

        public void setValue(float newValue) {
            ((TFloatMap)TFloatMap.this).values[this.i] = newValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator<Entry> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            return new Entry(this.nextIndex());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySet
    extends AbstractSet<Entry> {
        @Override
        public Iterator<Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return TFloatMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryValueComparator
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            return Double.compare(TFloatMap.this.values[e1.i], TFloatMap.this.values[e2.i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FullEntry
    implements Comparable<FullEntry> {
        private final T key;
        private final float value;

        private FullEntry(T key, float value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(FullEntry e) {
            int h2;
            int h1 = TFloatMap.this.hash(this.key);
            if (h1 != (h2 = TFloatMap.this.hash(e.key))) {
                return h1 - h2;
            }
            return ((Comparable)this.key).compareTo(e.key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends MapIterator<T> {
        private KeyIterator() {
        }

        @Override
        public T next() {
            return TFloatMap.this.keys[this.nextIndex()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeySet
    extends AbstractSet<T> {
        @Override
        public Iterator<T> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TFloatMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            return TFloatMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MapIterator<E>
    implements Iterator<E> {
        private int next;
        private int end;

        public MapIterator() {
            this.end = TFloatMap.this.mapType == AbstractTMap.MapType.SORTED_LIST ? TFloatMap.this.size() : TFloatMap.this.capacity();
            this.next = -1;
            this.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.next < this.end;
        }

        int nextIndex() {
            int curr = this.next;
            do {
                ++this.next;
            } while (this.next < this.end && TFloatMap.this.keys[this.next] == null);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueCollection
    extends AbstractCollection<Float> {
        @Override
        public Iterator<Float> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TFloatMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends MapIterator<Float> {
        private ValueIterator() {
        }

        @Override
        public Float next() {
            return Float.valueOf(TFloatMap.this.values[this.nextIndex()]);
        }
    }
}

