/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Trie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieWithBackPointers<K, V>
extends Trie<K, V> {
    private Trie<K, V> backPointer;
    private K k;

    @Override
    protected Trie<K, V> newTrie(boolean useIdentity2, K first, V v2, Trie<K, V> trie) {
        return new TrieWithBackPointers<K, V>(useIdentity2, first, v2, trie);
    }

    public TrieWithBackPointers(boolean useIdentity) {
        this(useIdentity, null, null, null);
    }

    public TrieWithBackPointers() {
        this(false, null, null, null);
    }

    private TrieWithBackPointers(boolean useIdentity, K k, V v, Trie<K, V> backPointer) {
        super(useIdentity, k, v, backPointer);
        this.backPointer = backPointer;
        this.k = k;
    }

    public Trie<K, V> getPreviousTrie() {
        return this.backPointer;
    }

    @Override
    public TrieWithBackPointers<K, V> getNextTrie(K k) {
        return (TrieWithBackPointers)super.getNextTrie(k);
    }

    public List<K> retraceBackPointers() {
        ArrayList list = new ArrayList();
        this.retraceFromNodeHelper(list);
        Collections.reverse(list);
        return list;
    }

    private void retraceFromNodeHelper(List<K> list) {
        if (this.k == null) {
            return;
        }
        list.add(this.k);
        ((TrieWithBackPointers)this.backPointer).retraceFromNodeHelper(list);
    }
}

