/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Counter;
import java.text.NumberFormat;
import java.util.Map;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableSizeHistogram {
    private SortedSet<Double> startPoints;
    private Counter<Number> data;
    private boolean intKeys;

    public VariableSizeHistogram(SortedSet<Double> startPoints) {
        this(startPoints, true);
    }

    public VariableSizeHistogram(SortedSet<Double> startPoints, boolean intKeys) {
        this.startPoints = startPoints;
        this.intKeys = intKeys;
        this.data = new Counter();
    }

    public void add(double key, double value) {
        SortedSet<Double> tailSet = this.startPoints.tailSet(key);
        Double startPoint = tailSet.isEmpty() ? this.startPoints.last() : tailSet.first();
        this.data.incrementCount(startPoint, value);
    }

    public void addAll(Counter<? extends Number> counter) {
        for (Map.Entry<? extends Number, Double> entry : counter.entrySet()) {
            this.add(entry.getKey().doubleValue(), entry.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(5);
        Number previous = null;
        for (Number number : this.startPoints) {
            if (previous != null) {
                Number rangeEnd = null;
                if (this.intKeys) {
                    int prev;
                    int num = number.intValue() - 1;
                    if (num != (prev = previous.intValue())) {
                        rangeEnd = num;
                    }
                } else {
                    rangeEnd = number;
                }
                sb.append(String.valueOf(f.format(previous)) + (rangeEnd == null ? "" : "-" + f.format(rangeEnd)));
                sb.append(" : ");
                sb.append(f.format(this.data.getCount(number)));
                sb.append(", ");
            }
            previous = number;
        }
        sb.append(String.valueOf(f.format(previous)) + "-");
        sb.append(" : ");
        sb.append(f.format(this.data.getCount(previous)));
        sb.append("]");
        return sb.toString();
    }
}

