/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util.functional;

import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.Factory;
import edu.berkeley.nlp.util.LazyIterable;
import edu.berkeley.nlp.util.Pair;
import edu.berkeley.nlp.util.functional.Function;
import edu.berkeley.nlp.util.functional.Predicate;
import edu.berkeley.nlp.util.functional.Predicates;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalUtils {
    public static <T> List<T> take(Iterator<T> it, int n) {
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        while (i < n && it.hasNext()) {
            result.add(it.next());
            ++i;
        }
        return result;
    }

    private static Method getMethod(Class c, String field) {
        Method[] methods = c.getDeclaredMethods();
        String trgMethName = "get" + field;
        Object trgMeth = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equalsIgnoreCase(trgMethName) || m.getName().equalsIgnoreCase(field)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static Field getField(Class c, String fieldName) {
        Field[] fields;
        Field[] fieldArray = fields = c.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getName().equalsIgnoreCase(fieldName)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static <T> Pair<T, Double> findMax(Iterable<T> xs, Function<T, Double> fn) {
        double max = Double.NEGATIVE_INFINITY;
        Object argMax = null;
        for (T x : xs) {
            double val = fn.apply(x);
            if (!(val > max)) continue;
            max = val;
            argMax = x;
        }
        return Pair.newPair(argMax, max);
    }

    public static <T> Pair<T, Double> findMin(Iterable<T> xs, Function<T, Double> fn) {
        double min = Double.POSITIVE_INFINITY;
        Object argMin = null;
        for (T x : xs) {
            double val = fn.apply(x);
            if (!(val < min)) continue;
            min = val;
            argMin = x;
        }
        return Pair.newPair(argMin, min);
    }

    public static <K, I, V> Map<K, V> compose(Map<K, I> map, Function<I, V> fn) {
        return FunctionalUtils.map(map, fn, Predicates.getTruePredicate(), new HashMap());
    }

    public static <K, I, V> Map<K, V> compose(Map<K, I> map, Function<I, V> fn, Predicate<K> pred) {
        return FunctionalUtils.map(map, fn, pred, new HashMap());
    }

    public static <C> List make(Factory<C> factory, int k) {
        ArrayList<C> insts = new ArrayList<C>();
        int i = 0;
        while (i < k) {
            insts.add(factory.newInstance(new Object[0]));
            ++i;
        }
        return insts;
    }

    public static <K, I, V> Map<K, V> map(Map<K, I> map, Function<I, V> fn, Predicate<K> pred, Map<K, V> resultMap) {
        for (Map.Entry<K, I> entry : map.entrySet()) {
            K key = entry.getKey();
            I inter = entry.getValue();
            if (!((Boolean)pred.apply(key)).booleanValue()) continue;
            resultMap.put(key, fn.apply(inter));
        }
        return resultMap;
    }

    public static <I, O> Map<I, O> mapPairs(Iterable<I> lst, Function<I, O> fn) {
        return FunctionalUtils.mapPairs(lst, fn, new HashMap());
    }

    public static <I, O> Map<I, O> mapPairs(Iterable<I> lst, Function<I, O> fn, Map<I, O> resultMap) {
        for (I input : lst) {
            O output = fn.apply(input);
            resultMap.put(input, output);
        }
        return resultMap;
    }

    public static <I, O> List<O> map(Iterable<I> lst, Function<I, O> fn) {
        return FunctionalUtils.map(lst, fn, Predicates.getTruePredicate());
    }

    public static <I, O> Iterable<O> lazyMap(Iterable<I> lst, Function<I, O> fn) {
        return FunctionalUtils.lazyMap(lst, fn, Predicates.getTruePredicate());
    }

    public static <I, O> Iterable<O> lazyMap(Iterable<I> lst, Function<I, O> fn, Predicate<O> pred) {
        return new LazyIterable<O, I>(lst, fn, pred, 20);
    }

    public static <I, O> List<O> flatMap(Iterable<I> lst, Function<I, List<O>> fn) {
        Predicate<List<O>> p = Predicates.getTruePredicate();
        return FunctionalUtils.flatMap(lst, fn, p);
    }

    public static <I, O> List<O> flatMap(Iterable<I> lst, Function<I, List<O>> fn, Predicate<List<O>> pred) {
        List<List<O>> lstOfLsts = FunctionalUtils.map(lst, fn, pred);
        ArrayList init = new ArrayList();
        return FunctionalUtils.reduce(lstOfLsts, init, new Function<Pair<List<O>, List<O>>, List<O>>(){

            @Override
            public List<O> apply(Pair<List<O>, List<O>> input) {
                List result = input.getFirst();
                result.addAll(input.getSecond());
                return result;
            }
        });
    }

    public static <I, O> O reduce(Iterable<I> inputs, O initial, Function<Pair<O, I>, O> fn) {
        O output = initial;
        for (I input : inputs) {
            output = fn.apply(Pair.newPair(output, input));
        }
        return output;
    }

    public static <I, O> List<O> map(Iterable<I> lst, Function<I, O> fn, Predicate<O> pred) {
        ArrayList<O> outputs = new ArrayList<O>();
        for (I input : lst) {
            O output = fn.apply(input);
            if (!((Boolean)pred.apply(output)).booleanValue()) continue;
            outputs.add(output);
        }
        return outputs;
    }

    public static <I> List<I> filter(Iterable<I> lst, Predicate<I> pred) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I input : lst) {
            if (!((Boolean)pred.apply(input)).booleanValue()) continue;
            ret.add(input);
        }
        return ret;
    }

    public static <O, T> Function getAccessor(String field, Class c) {
        final Method trgMeth = FunctionalUtils.getMethod(c, field);
        final Field trgField = FunctionalUtils.getField(c, field);
        if (trgMeth == null && trgField == null) {
            throw new RuntimeException("Couldn't find field or method to access " + field);
        }
        return new Function<O, T>(){

            @Override
            public T apply(O input) {
                try {
                    return trgMeth != null ? trgMeth.invoke(input, new Object[0]) : trgField.get(input);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error accessing Method or target");
                }
            }
        };
    }

    public static <K, O> Map<K, Collection<O>> groupBy(Iterable<O> objs, Function<O, K> groupFn) {
        return FunctionalUtils.groupBy(objs, groupFn, new Factory<Collection<O>>(){

            @Override
            public Collection<O> newInstance(Object ... args) {
                return new ArrayList();
            }
        });
    }

    public static <K, O> Map<K, Collection<O>> groupBy(Iterable<O> objs, String field) {
        return FunctionalUtils.groupBy(objs, FunctionalUtils.getAccessor(field, objs.iterator().next().getClass()));
    }

    public static <K, O, C extends Collection<O>> Map<K, C> groupBy(Iterable<O> objs, Function<O, K> groupFn, Factory<C> fact) {
        Iterator<O> it = objs.iterator();
        if (!it.hasNext()) {
            return new HashMap();
        }
        HashMap map = new HashMap();
        for (O obj : objs) {
            Object key = null;
            try {
                key = groupFn.apply(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            CollectionUtils.addToValueCollection(map, key, obj, fact);
        }
        return map;
    }

    public static <T> T first(Iterable<T> objs, Predicate<T> pred) {
        for (T obj : objs) {
            if (!((Boolean)pred.apply(obj)).booleanValue()) continue;
            return obj;
        }
        return null;
    }

    public static <O, K> List<O> filter(Iterable<O> coll, String field, final K value) throws Exception {
        Iterator<O> it = coll.iterator();
        if (!it.hasNext()) {
            return new ArrayList();
        }
        Class<?> c = it.next().getClass();
        final Method m = FunctionalUtils.getMethod(c, field);
        final Field f = FunctionalUtils.getField(c, field);
        return FunctionalUtils.filter(coll, new Predicate<O>(){

            @Override
            public Boolean apply(O input) {
                try {
                    Object inputVal = m != null ? m.invoke(input, new Object[0]) : f.get(input);
                    return inputVal.equals(value);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
    }

    public static List<Integer> range(int n) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < n) {
            result.add(i);
            ++i;
        }
        return result;
    }

    public static <T> T find(Iterable<T> elems, Predicate<T> pred) {
        for (T elem : elems) {
            if (!((Boolean)pred.apply(elem)).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        List<Person> objs = CollectionUtils.makeList(new Person("david"), new Person("davs"), new Person("maria"), new Person("marshia"));
        Map grouped = FunctionalUtils.groupBy(objs, FunctionalUtils.getAccessor("prefix", Person.class));
        System.out.printf("groupd: %s", grouped);
    }

    private static class Person {
        public String prefix;
        public String name;

        public Person(String name) {
            this.name = name;
            this.prefix = name.substring(0, 3);
        }

        public String toString() {
            return "Person(" + this.name + ")";
        }
    }
}

