/*
 * Decompiled with CFR 0.152.
 */
package org.doxygen.tools;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.doxygen.tools.DoxygenConfig;
import org.doxygen.tools.DoxygenProcess;

public class DoxygenTask
extends Task {
    public static String CONFIG_FILE = "";
    private DoxygenConfig conf;
    private DoxygenProcess proc;
    private static boolean verbose;
    private String versionCompatible = null;
    private String configFilename = null;
    private Project antProject = this.getProject();

    public DoxygenTask() {
        String projectName;
        this.proc = new DoxygenProcess();
        this.conf = new DoxygenConfig();
        if (this.antProject != null && (projectName = this.antProject.getName()) != null) {
            this.conf.setProperty("PROJECT_NAME", projectName);
        }
    }

    public final void execute() throws BuildException {
        this.proc.checkVersion(this.versionCompatible);
        if (this.configFilename == null) {
            this.configFilename = CONFIG_FILE;
            this.proc.createConfig(this.configFilename);
        }
        this.conf.writeDoxygenConfig(this.configFilename);
        this.proc.executeDoxygenConfig(this.configFilename);
    }

    public final void setVerbose(boolean attr) {
        verbose = attr;
    }

    public final void setDoxygenPath(String attr) {
        this.proc.setDoxygenPath(attr);
    }

    public final void setVersionCompatible(String newVersion) {
        this.versionCompatible = newVersion;
    }

    public final void setConfigFilename(String attr) {
        this.configFilename = attr;
    }

    public final boolean getVerbose() {
        return verbose;
    }

    public final String getVersionCompatible() {
        return this.versionCompatible;
    }

    public final String getConfigFilename() {
        return this.configFilename;
    }

    public final Property createProperty() {
        return new Property();
    }

    public final void addConfiguredProperty(Property p) {
        this.conf.setProperty(p.getName(), p.getValue());
    }

    final void setProperty(String propertyName, String propertyValue) {
        this.conf.setProperty(propertyName, propertyValue);
    }

    final Property getProperty(String propertyName) {
        return this.conf.getProperty(propertyName);
    }

    public static final void activityLog(boolean terseMessage, String theMessage) {
        if (theMessage != null && (terseMessage || verbose)) {
            System.out.println(theMessage);
        }
    }

    static {
        try {
            CONFIG_FILE = File.createTempFile("doxygen", ".cfg").getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        verbose = false;
    }

    public static class Property {
        private String key = null;
        private String val = null;

        public final String getName() {
            return this.key;
        }

        public final String getValue() {
            return this.val;
        }

        public final void setName(String theNewName) {
            this.key = theNewName;
        }

        public final void setValue(String theNewValue) {
            this.val = theNewValue.toLowerCase().equals("true") ? "YES" : (theNewValue.toLowerCase().equals("false") ? "NO" : theNewValue);
        }

        public final String toString() {
            return "Property=[key={" + this.key + "}," + "value={" + this.val + "}" + "]";
        }
    }
}

