/*
 * Decompiled with CFR 0.152.
 */
package org.doxygen.tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenVersion
implements Comparable<DoxygenVersion> {
    private int[] versions;
    private static final int DEFAULT_MAGNITUDE = 3;
    private boolean upwards = false;

    public DoxygenVersion(String releaseMajorMinor, int orderOfMagnitude) {
        String[] st;
        String version = releaseMajorMinor;
        if (version.endsWith("+")) {
            this.upwards = true;
            int len = version.length();
            version = version.substring(0, len - 1);
        }
        if ((st = version.split("\\.")).length != orderOfMagnitude) {
            throw new IllegalArgumentException(String.format("doxygen --version (%s) . Number of tokens retrieved %d does not match expected %d tokens", version, st.length, orderOfMagnitude));
        }
        this.versions = new int[orderOfMagnitude];
        for (int i = 0; i < orderOfMagnitude; ++i) {
            this.versions[i] = Integer.parseInt(st[i]);
        }
    }

    public DoxygenVersion(String releaseMajorMinor) {
        this(releaseMajorMinor, 3);
    }

    @Override
    public final int compareTo(DoxygenVersion dv) {
        if (!this.upwards && this.versions.length != dv.versions.length) {
            return -1;
        }
        for (int i = 0; i < this.versions.length; ++i) {
            if (i > this.versions.length || i > dv.versions.length) continue;
            if (this.versions[i] > dv.versions[i]) {
                return 1;
            }
            if (this.versions[i] == dv.versions[i]) continue;
            return -1;
        }
        return 0;
    }

    public final boolean isCompatible(String version) {
        DoxygenVersion compatVersion = new DoxygenVersion(version);
        System.out.println("DoxygenVersion.isCompatible([" + version + "]) => [" + compatVersion.versions.length + "]");
        if (compatVersion.upwards) {
            return this.compareTo(compatVersion) >= 0;
        }
        return this.compareTo(compatVersion) == 0;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i : this.versions) {
            sb.append(i + ".");
        }
        return sb.toString();
    }
}

