/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.ProgressEvent;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.UploadPartCallable;
import com.amazonaws.services.s3.transfer.internal.UploadPartRequestFactory;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartUploadCallable
implements Callable<UploadResult> {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private static final Log log = LogFactory.getLog(MultipartUploadCallable.class);
    private final TransferManagerConfiguration configuration;
    private final ProgressListenerChain progressListenerChain;

    public MultipartUploadCallable(TransferManager transferManager, ExecutorService threadPool, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.progressListenerChain = progressListenerChain;
    }

    @Override
    public UploadResult call() throws Exception {
        String bucketName = this.putObjectRequest.getBucketName();
        String key = this.putObjectRequest.getKey();
        this.fireProgressEvent(1);
        String uploadId = this.initiateMultipartUpload(this.putObjectRequest);
        long optimalPartSize = TransferManagerUtils.calculateOptimalPartSize(this.putObjectRequest, this.configuration);
        log.debug((Object)("Calculated optimal part size: " + optimalPartSize));
        try {
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            UploadPartRequestFactory requestFactory = new UploadPartRequestFactory(this.putObjectRequest, uploadId, optimalPartSize);
            if (TransferManagerUtils.isUploadParallelizable(this.putObjectRequest)) {
                ArrayList<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
                while (requestFactory.hasMoreRequests()) {
                    if (this.threadPool.isShutdown()) {
                        throw new CancellationException("TransferManager has been shutdown");
                    }
                    UploadPartRequest request = requestFactory.getNextUploadPartRequest();
                    futures.add(this.threadPool.submit(new UploadPartCallable(this.s3, request)));
                }
                this.collectPartETags(futures, partETags);
            } else {
                while (requestFactory.hasMoreRequests()) {
                    if (this.threadPool.isShutdown()) {
                        throw new CancellationException("TransferManager has been shutdown");
                    }
                    partETags.add(this.s3.uploadPart(requestFactory.getNextUploadPartRequest()).getPartETag());
                }
            }
            CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags));
            this.fireProgressEvent(2);
            UploadResult uploadResult = new UploadResult();
            uploadResult.setBucketName(completeMultipartUploadResult.getBucketName());
            uploadResult.setKey(completeMultipartUploadResult.getKey());
            uploadResult.setETag(completeMultipartUploadResult.getETag());
            uploadResult.setVersionId(completeMultipartUploadResult.getVersionId());
            UploadResult uploadResult2 = uploadResult;
            return uploadResult2;
        }
        catch (Exception e) {
            this.fireProgressEvent(4);
            try {
                this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, key, uploadId));
            }
            catch (Exception e2) {
                log.info((Object)("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + e2.getMessage()), (Throwable)e2);
            }
            throw e;
        }
        finally {
            if (this.putObjectRequest.getInputStream() != null) {
                try {
                    this.putObjectRequest.getInputStream().close();
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to cleanly close input stream: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        if (putObjectRequest.getStorageClass() != null) {
            initiateMultipartUploadRequest.setStorageClass(StorageClass.fromValue(putObjectRequest.getStorageClass()));
        }
        String uploadId = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug((Object)("Initiated new multipart upload: " + uploadId));
        return uploadId;
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChain == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0);
        event.setEventCode(eventType);
        this.progressListenerChain.progressChanged(event);
    }

    private void collectPartETags(List<Future<PartETag>> futures, List<PartETag> partETags) {
        for (Future<PartETag> future : futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to upload part: " + e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

