/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.AbstractByte2IntMap;
import it.unimi.dsi.fastutil.bytes.AbstractByte2IntSortedMap;
import it.unimi.dsi.fastutil.bytes.AbstractByteSortedSet;
import it.unimi.dsi.fastutil.bytes.Byte2IntMap;
import it.unimi.dsi.fastutil.bytes.Byte2IntSortedMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBidirectionalIterator;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteSortedSet;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Byte2IntLinkedOpenHashMap
extends AbstractByte2IntSortedMap
implements Serializable,
Cloneable,
Hash {
    protected transient byte[] key;
    protected transient int[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Byte2IntSortedMap.FastSortedEntrySet entries;
    protected volatile transient ByteSortedSet keys;
    protected volatile transient IntCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Byte2IntLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new byte[this.free];
        this.value = new int[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Byte2IntLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Byte2IntLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Byte2IntLinkedOpenHashMap(Map<? extends Byte, ? extends Integer> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2IntLinkedOpenHashMap(Map<? extends Byte, ? extends Integer> m) {
        this(m, 0.75f);
    }

    public Byte2IntLinkedOpenHashMap(Byte2IntMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2IntLinkedOpenHashMap(Byte2IntMap m) {
        this(m, 0.75f);
    }

    public Byte2IntLinkedOpenHashMap(byte[] k, int[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Byte2IntLinkedOpenHashMap(byte[] k, int[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] == -1 && k != key[h1]);
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public int put(byte k, int v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            int oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Integer put(Byte ok, Integer ov) {
        int v = ov;
        byte k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            int oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(int v) {
        int[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public byte firstByteKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public byte lastByteKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ByteComparator comparator() {
        return null;
    }

    @Override
    public Byte2IntSortedMap tailMap(byte from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte2IntSortedMap headMap(byte to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte2IntSortedMap subMap(byte from, byte to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(byte k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int get(byte k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public int remove(byte k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    public Integer get(Byte ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Integer.valueOf(this.value[i]);
    }

    @Override
    public Integer remove(Object ok) {
        int i = this.findKey((Byte)ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    public Byte2IntSortedMap.FastSortedEntrySet byte2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ByteSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                public IntIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Byte2IntLinkedOpenHashMap.this.count;
                }

                public boolean contains(int v) {
                    return Byte2IntLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Byte2IntLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        byte[] key = this.key;
        byte[] newKey = new byte[newN];
        int[] value = this.value;
        int[] newValue = new int[newN];
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            byte k = key[i];
            int v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                do {
                    if ((h1 += h2) < newN && h1 >= 0) continue;
                    h1 -= newN;
                } while (newState[h1] != 0);
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Byte2IntLinkedOpenHashMap c;
        try {
            c = (Byte2IntLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (byte[])this.key.clone();
        c.value = (int[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        byte[] key = this.key;
        int[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeByte(key[e]);
            s.writeInt(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new byte[n];
        byte[] key = this.key;
        this.value = new int[n];
        int[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            byte k = s.readByte();
            int v = s.readInt();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                do {
                    if ((h1 += h2) < n && h1 >= 0) continue;
                    h1 -= n;
                } while (state[h1] != 0);
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements IntListIterator {
        public int previousInt() {
            return Byte2IntLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Integer previous() {
            return Byte2IntLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public void set(Integer ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Integer ok) {
            throw new UnsupportedOperationException();
        }

        public void set(int v) {
            throw new UnsupportedOperationException();
        }

        public void add(int v) {
            throw new UnsupportedOperationException();
        }

        public int nextInt() {
            return Byte2IntLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Integer next() {
            return Byte2IntLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractByteSortedSet {
        private KeySet() {
        }

        public ByteBidirectionalIterator iterator(byte from) {
            return new KeyIterator(from);
        }

        public ByteBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Byte2IntLinkedOpenHashMap.this.count;
        }

        public boolean contains(byte k) {
            return Byte2IntLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(byte k) {
            int oldCount = Byte2IntLinkedOpenHashMap.this.count;
            Byte2IntLinkedOpenHashMap.this.remove(k);
            return Byte2IntLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Byte2IntLinkedOpenHashMap.this.clear();
        }

        public byte firstByte() {
            if (Byte2IntLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Byte2IntLinkedOpenHashMap.this.key[Byte2IntLinkedOpenHashMap.this.first];
        }

        public byte lastByte() {
            if (Byte2IntLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Byte2IntLinkedOpenHashMap.this.key[Byte2IntLinkedOpenHashMap.this.last];
        }

        public ByteComparator comparator() {
            return null;
        }

        public final ByteSortedSet tailSet(byte from) {
            throw new UnsupportedOperationException();
        }

        public final ByteSortedSet headSet(byte to) {
            throw new UnsupportedOperationException();
        }

        public final ByteSortedSet subSet(byte from, byte to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ByteListIterator {
        public KeyIterator(byte k) {
            super(k);
        }

        public byte previousByte() {
            return Byte2IntLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(byte k) {
            throw new UnsupportedOperationException();
        }

        public void add(byte k) {
            throw new UnsupportedOperationException();
        }

        public Byte previous() {
            return Byte2IntLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        public byte nextByte() {
            return Byte2IntLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Byte next() {
            return Byte2IntLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSortedSet<Byte2IntMap.Entry>
    implements Byte2IntSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Byte2IntMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Byte2IntMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Byte2IntMap.Entry> subSet(Byte2IntMap.Entry fromElement, Byte2IntMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Byte2IntMap.Entry> headSet(Byte2IntMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Byte2IntMap.Entry> tailSet(Byte2IntMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte2IntMap.Entry first() {
            if (Byte2IntLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Byte2IntLinkedOpenHashMap.this.first);
        }

        @Override
        public Byte2IntMap.Entry last() {
            if (Byte2IntLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Byte2IntLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Byte2IntLinkedOpenHashMap.this.findKey((Byte)e.getKey());
            return i >= 0 && Byte2IntLinkedOpenHashMap.this.value[i] == (Integer)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Byte2IntLinkedOpenHashMap.this.findKey((Byte)e.getKey());
            if (i >= 0) {
                Byte2IntLinkedOpenHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Byte2IntLinkedOpenHashMap.this.count;
        }

        @Override
        public void clear() {
            Byte2IntLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Byte2IntMap.Entry> iterator(Byte2IntMap.Entry from) {
            return new EntryIterator((Byte)from.getKey());
        }

        public ObjectBidirectionalIterator<Byte2IntMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Byte2IntMap.Entry> fastIterator(Byte2IntMap.Entry from) {
            return new FastEntryIterator((Byte)from.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Byte2IntMap.Entry> {
        final AbstractByte2IntMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractByte2IntMap.BasicEntry(0, 0);
        }

        public FastEntryIterator(byte from) {
            super(from);
            this.entry = new AbstractByte2IntMap.BasicEntry(0, 0);
        }

        @Override
        public AbstractByte2IntMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Byte2IntLinkedOpenHashMap.this.key[e];
            this.entry.value = Byte2IntLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractByte2IntMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Byte2IntLinkedOpenHashMap.this.key[e];
            this.entry.value = Byte2IntLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Byte2IntMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte2IntMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Byte2IntMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(byte from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Byte2IntMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte2IntMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Byte2IntLinkedOpenHashMap.this.first;
        }

        MapIterator(byte from) {
            if (Byte2IntLinkedOpenHashMap.this.key[Byte2IntLinkedOpenHashMap.this.last] == from) {
                this.prev = Byte2IntLinkedOpenHashMap.this.last;
                this.index = Byte2IntLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Byte2IntLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Byte2IntLinkedOpenHashMap.this.first;
                while (Byte2IntLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Byte2IntLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Byte2IntLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Byte2IntLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Byte2IntLinkedOpenHashMap.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Byte2IntLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Byte2IntLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Byte2IntLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Byte2IntLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Byte2IntLinkedOpenHashMap.this.link[n] = Byte2IntLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Byte2IntLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Byte2IntLinkedOpenHashMap.this.link[n] = Byte2IntLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Byte2IntMap.Entry,
    Map.Entry<Byte, Integer> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Byte getKey() {
            return Byte2IntLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public byte getByteKey() {
            return Byte2IntLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Integer getValue() {
            return Byte2IntLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public int getIntValue() {
            return Byte2IntLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public int setValue(int v) {
            int oldValue = Byte2IntLinkedOpenHashMap.this.value[this.index];
            Byte2IntLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Integer setValue(Integer v) {
            return this.setValue((int)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Byte2IntLinkedOpenHashMap.this.key[this.index] == (Byte)e.getKey() && Byte2IntLinkedOpenHashMap.this.value[this.index] == (Integer)e.getValue();
        }

        @Override
        public int hashCode() {
            return Byte2IntLinkedOpenHashMap.this.key[this.index] ^ Byte2IntLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Byte2IntLinkedOpenHashMap.this.key[this.index] + "->" + Byte2IntLinkedOpenHashMap.this.value[this.index];
        }
    }
}

