/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.AbstractByte2LongMap;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2LongMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Byte2LongOpenHashMap
extends AbstractByte2LongMap
implements Serializable,
Cloneable,
Hash {
    protected transient byte[] key;
    protected transient long[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Byte2LongMap.FastEntrySet entries;
    protected volatile transient ByteSet keys;
    protected volatile transient LongCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Byte2LongOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new byte[this.free];
        this.value = new long[this.free];
        this.state = new byte[this.free];
    }

    public Byte2LongOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Byte2LongOpenHashMap() {
        this(16, 0.75f);
    }

    public Byte2LongOpenHashMap(Map<? extends Byte, ? extends Long> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2LongOpenHashMap(Map<? extends Byte, ? extends Long> m) {
        this(m, 0.75f);
    }

    public Byte2LongOpenHashMap(Byte2LongMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2LongOpenHashMap(Byte2LongMap m) {
        this(m, 0.75f);
    }

    public Byte2LongOpenHashMap(byte[] k, long[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Byte2LongOpenHashMap(byte[] k, long[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] == -1 && k != key[h1]);
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public long put(byte k, long v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Long put(Byte ok, Long ov) {
        long v = ov;
        byte k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(long v) {
        long[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
    }

    @Override
    public boolean containsKey(byte k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public long get(byte k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public long remove(byte k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Long get(Byte ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Long.valueOf(this.value[i]);
    }

    @Override
    public Long remove(Object ok) {
        int i = this.findKey((Byte)ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Byte2LongMap.FastEntrySet byte2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ByteSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                public LongIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Byte2LongOpenHashMap.this.count;
                }

                public boolean contains(long v) {
                    return Byte2LongOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Byte2LongOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        byte[] state = this.state;
        int newN = PRIMES[newP];
        byte[] key = this.key;
        byte[] newKey = new byte[newN];
        long[] value = this.value;
        long[] newValue = new long[newN];
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            byte k = key[i];
            long v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                do {
                    if ((h1 += h2) < newN && h1 >= 0) continue;
                    h1 -= newN;
                } while (newState[h1] != 0);
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Byte2LongOpenHashMap c;
        try {
            c = (Byte2LongOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (byte[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        byte[] key = this.key;
        long[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeByte(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new byte[n];
        byte[] key = this.key;
        this.value = new long[n];
        long[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            byte k = s.readByte();
            long v = s.readLong();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                do {
                    if ((h1 += h2) < n && h1 >= 0) continue;
                    h1 -= n;
                } while (state[h1] != 0);
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements LongIterator {
        public long nextLong() {
            return Byte2LongOpenHashMap.this.value[this.nextEntry()];
        }

        public Long next() {
            return Byte2LongOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractByteSet {
        private KeySet() {
        }

        public ByteIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Byte2LongOpenHashMap.this.count;
        }

        public boolean contains(byte k) {
            return Byte2LongOpenHashMap.this.containsKey(k);
        }

        public boolean remove(byte k) {
            int oldCount = Byte2LongOpenHashMap.this.count;
            Byte2LongOpenHashMap.this.remove(k);
            return Byte2LongOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Byte2LongOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ByteIterator {
        public byte nextByte() {
            return Byte2LongOpenHashMap.this.key[this.nextEntry()];
        }

        public Byte next() {
            return Byte2LongOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Byte2LongMap.Entry>
    implements Byte2LongMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Byte2LongMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Byte2LongMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Byte2LongOpenHashMap.this.findKey((Byte)e.getKey());
            return i >= 0 && Byte2LongOpenHashMap.this.value[i] == (Long)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Byte2LongOpenHashMap.this.findKey((Byte)e.getKey());
            if (i >= 0) {
                Byte2LongOpenHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Byte2LongOpenHashMap.this.count;
        }

        @Override
        public void clear() {
            Byte2LongOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Byte2LongMap.Entry> {
        final AbstractByte2LongMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractByte2LongMap.BasicEntry(0, 0L);
        }

        @Override
        public AbstractByte2LongMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Byte2LongOpenHashMap.this.key[e];
            this.entry.value = Byte2LongOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Byte2LongMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Byte2LongMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Byte2LongOpenHashMap.this.count;
            byte[] state = Byte2LongOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Byte2LongOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Byte2LongOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Byte2LongOpenHashMap.this.state[this.last] = 1;
            --Byte2LongOpenHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Byte2LongMap.Entry,
    Map.Entry<Byte, Long> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Byte getKey() {
            return Byte2LongOpenHashMap.this.key[this.index];
        }

        @Override
        public byte getByteKey() {
            return Byte2LongOpenHashMap.this.key[this.index];
        }

        @Override
        public Long getValue() {
            return Byte2LongOpenHashMap.this.value[this.index];
        }

        @Override
        public long getLongValue() {
            return Byte2LongOpenHashMap.this.value[this.index];
        }

        @Override
        public long setValue(long v) {
            long oldValue = Byte2LongOpenHashMap.this.value[this.index];
            Byte2LongOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Byte2LongOpenHashMap.this.key[this.index] == (Byte)e.getKey() && Byte2LongOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        @Override
        public int hashCode() {
            return Byte2LongOpenHashMap.this.key[this.index] ^ HashCommon.long2int(Byte2LongOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Byte2LongOpenHashMap.this.key[this.index] + "->" + Byte2LongOpenHashMap.this.value[this.index];
        }
    }
}

