/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleListIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleLinkedOpenHashSet
extends AbstractDoubleSortedSet
implements Serializable,
Cloneable,
Hash {
    protected transient double[] key;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public DoubleLinkedOpenHashSet(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new double[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public DoubleLinkedOpenHashSet(int n) {
        this(n, 0.75f);
    }

    public DoubleLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    public DoubleLinkedOpenHashSet(Collection<? extends Double> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public DoubleLinkedOpenHashSet(Collection<? extends Double> c) {
        this(c, 0.75f);
    }

    public DoubleLinkedOpenHashSet(DoubleCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public DoubleLinkedOpenHashSet(DoubleCollection c) {
        this(c, 0.75f);
    }

    public DoubleLinkedOpenHashSet(DoubleIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextDouble());
        }
    }

    public DoubleLinkedOpenHashSet(DoubleIterator i) {
        this(i, 0.75f);
    }

    public DoubleLinkedOpenHashSet(Iterator<?> i, float f) {
        this(DoubleIterators.asDoubleIterator(i), f);
    }

    public DoubleLinkedOpenHashSet(Iterator<?> i) {
        this(DoubleIterators.asDoubleIterator(i));
    }

    public DoubleLinkedOpenHashSet(double[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        DoubleArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public DoubleLinkedOpenHashSet(double[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public DoubleLinkedOpenHashSet(double[] a, float f) {
        this(a, 0, a.length, f);
    }

    public DoubleLinkedOpenHashSet(double[] a) {
        this(a, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(double k) {
        double[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] == -1 && k != key[h1]);
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(double k) {
        double[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public boolean add(double k) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            return false;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return true;
    }

    @Override
    public boolean remove(double k) {
        int i = this.findKey(k);
        if (i < 0) {
            return false;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return true;
    }

    @Override
    public boolean contains(double k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public double firstDouble() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDouble() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleSortedSet tailSet(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleSortedSet headSet(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleSortedSet subSet(double from, double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public DoubleBidirectionalIterator iterator(double from) {
        return new SetIterator(from);
    }

    @Override
    public DoubleBidirectionalIterator iterator() {
        return new SetIterator();
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        double[] key = this.key;
        double[] newKey = new double[newN];
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            double k = key[i];
            int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            if (newState[h1] != 0) {
                int h2 = k2i % (newN - 2) + 1;
                do {
                    if ((h1 += h2) < newN && h1 >= 0) continue;
                    h1 -= newN;
                } while (newState[h1] != 0);
            }
            newState[h1] = -1;
            newKey[h1] = k;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object clone() {
        DoubleLinkedOpenHashSet c;
        try {
            c = (DoubleLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (double[])this.key.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            h += HashCommon.double2int(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        DoubleBidirectionalIterator i = this.iterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            s.writeDouble(i.nextDouble());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new double[n];
        double[] key = this.key;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            double k = s.readDouble();
            int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                do {
                    if ((h1 += h2) < n && h1 >= 0) continue;
                    h1 -= n;
                } while (state[h1] != 0);
            }
            state[h1] = -1;
            key[h1] = k;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractDoubleListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        SetIterator() {
            this.next = DoubleLinkedOpenHashSet.this.first;
        }

        SetIterator(double from) {
            if (DoubleLinkedOpenHashSet.this.key[DoubleLinkedOpenHashSet.this.last] == from) {
                this.prev = DoubleLinkedOpenHashSet.this.last;
                this.index = DoubleLinkedOpenHashSet.this.count;
            } else {
                double k;
                if (!DoubleLinkedOpenHashSet.this.contains(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = DoubleLinkedOpenHashSet.this.first;
                while ((k = this.nextDouble()) != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return DoubleLinkedOpenHashSet.this.key[this.curr];
        }

        public double previousDouble() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return DoubleLinkedOpenHashSet.this.key[this.curr];
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            DoubleLinkedOpenHashSet.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            } else {
                this.next = DoubleLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            }
            --DoubleLinkedOpenHashSet.this.count;
            if (this.prev == -1) {
                DoubleLinkedOpenHashSet.this.first = this.next;
            } else {
                int n = this.prev;
                DoubleLinkedOpenHashSet.this.link[n] = DoubleLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                DoubleLinkedOpenHashSet.this.last = this.prev;
            } else {
                int n = this.next;
                DoubleLinkedOpenHashSet.this.link[n] = DoubleLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }
    }
}

