/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloat2LongMap;
import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongCollections;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2LongArrayMap
extends AbstractFloat2LongMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient float[] key;
    private transient long[] value;
    private int size;

    public Float2LongArrayMap(float[] key, long[] value) {
        this.key = key;
        this.value = value;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Float2LongArrayMap() {
        this.key = FloatArrays.EMPTY_ARRAY;
        this.value = LongArrays.EMPTY_ARRAY;
    }

    public Float2LongArrayMap(int capacity) {
        this.key = new float[capacity];
        this.value = new long[capacity];
    }

    public Float2LongArrayMap(Float2LongMap m) {
        this(m.size());
        this.putAll(m);
    }

    public Float2LongArrayMap(float[] key, long[] value, int size) {
        this.key = key;
        this.value = value;
        this.size = size;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
        if (size > key.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the backing-arrays size (" + key.length + ")");
        }
    }

    public Float2LongMap.FastEntrySet float2LongEntrySet() {
        return new EntrySet();
    }

    private int findKey(float k) {
        float[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    public long get(float k) {
        float[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean containsKey(float k) {
        return this.findKey(k) != -1;
    }

    public boolean containsValue(long v) {
        int i = this.size;
        while (i-- != 0) {
            if (this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long put(float k, long v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            long oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            float[] newKey = new float[this.size == 0 ? 2 : this.size * 2];
            long[] newValue = new long[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                newKey[i] = this.key[i];
                newValue[i] = this.value[i];
            }
            this.key = newKey;
            this.value = newValue;
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    public long remove(float k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        long oldValue = this.value[oldPos];
        int tail = this.size - oldPos - 1;
        for (int i = 0; i < tail; ++i) {
            this.key[oldPos + i] = this.key[oldPos + i + 1];
            this.value[oldPos + i] = this.value[oldPos + i + 1];
        }
        --this.size;
        return oldValue;
    }

    public FloatSet keySet() {
        return new FloatArraySet(this.key, this.size);
    }

    public LongCollection values() {
        return LongCollections.unmodifiable(new LongArraySet(this.value, this.size));
    }

    public Object clone() {
        Float2LongArrayMap c;
        try {
            c = (Float2LongArrayMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (float[])this.key.clone();
        c.value = (long[])this.value.clone();
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeFloat(this.key[i]);
            s.writeLong(this.value[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.key = new float[this.size];
        this.value = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.key[i] = s.readFloat();
            this.value[i] = s.readLong();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractObjectSet<Float2LongMap.Entry>
    implements Float2LongMap.FastEntrySet {
        private EntrySet() {
        }

        @Override
        public ObjectIterator<Float2LongMap.Entry> iterator() {
            return new AbstractObjectIterator<Float2LongMap.Entry>(){
                int next = 0;

                @Override
                public boolean hasNext() {
                    return this.next < Float2LongArrayMap.this.size;
                }

                @Override
                public Float2LongMap.Entry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return new AbstractFloat2LongMap.BasicEntry(Float2LongArrayMap.this.key[this.next], Float2LongArrayMap.this.value[this.next++]);
                }
            };
        }

        @Override
        public ObjectIterator<Float2LongMap.Entry> fastIterator() {
            return new AbstractObjectIterator<Float2LongMap.Entry>(){
                int next = 0;
                final AbstractFloat2LongMap.BasicEntry entry = new AbstractFloat2LongMap.BasicEntry(0.0f, 0L);

                @Override
                public boolean hasNext() {
                    return this.next < Float2LongArrayMap.this.size;
                }

                @Override
                public Float2LongMap.Entry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.entry.key = Float2LongArrayMap.this.key[this.next];
                    this.entry.value = Float2LongArrayMap.this.value[this.next++];
                    return this.entry;
                }
            };
        }

        @Override
        public int size() {
            return Float2LongArrayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2LongArrayMap.this.containsKey(e.getKey()) && Float2LongArrayMap.this.get(e.getKey()) == e.getValue();
        }
    }
}

