/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ShortMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2ShortMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Float2ShortOpenHashMap
extends AbstractFloat2ShortMap
implements Serializable,
Cloneable,
Hash {
    protected transient float[] key;
    protected transient short[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Float2ShortMap.FastEntrySet entries;
    protected volatile transient FloatSet keys;
    protected volatile transient ShortCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Float2ShortOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new float[this.free];
        this.value = new short[this.free];
        this.state = new byte[this.free];
    }

    public Float2ShortOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Float2ShortOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2ShortOpenHashMap(Map<? extends Float, ? extends Short> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2ShortOpenHashMap(Map<? extends Float, ? extends Short> m) {
        this(m, 0.75f);
    }

    public Float2ShortOpenHashMap(Float2ShortMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2ShortOpenHashMap(Float2ShortMap m) {
        this(m, 0.75f);
    }

    public Float2ShortOpenHashMap(float[] k, short[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2ShortOpenHashMap(float[] k, short[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(float k) {
        float[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] == -1 && k != key[h1]);
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(float k) {
        float[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public short put(float k, short v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            short oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Short put(Float ok, Short ov) {
        short v = ov;
        float k = ok.floatValue();
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            short oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(short v) {
        short[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
    }

    @Override
    public boolean containsKey(float k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public short get(float k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public short remove(float k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Short get(Float ok) {
        int i = this.findKey(ok.floatValue());
        return i < 0 ? null : Short.valueOf(this.value[i]);
    }

    @Override
    public Short remove(Object ok) {
        int i = this.findKey(((Float)ok).floatValue());
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Float2ShortMap.FastEntrySet float2ShortEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ShortCollection values() {
        if (this.values == null) {
            this.values = new AbstractShortCollection(){

                public ShortIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Float2ShortOpenHashMap.this.count;
                }

                public boolean contains(short v) {
                    return Float2ShortOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Float2ShortOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        byte[] state = this.state;
        int newN = PRIMES[newP];
        float[] key = this.key;
        float[] newKey = new float[newN];
        short[] value = this.value;
        short[] newValue = new short[newN];
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            float k = key[i];
            short v = value[i];
            int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                do {
                    if ((h1 += h2) < newN && h1 >= 0) continue;
                    h1 -= newN;
                } while (newState[h1] != 0);
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Float2ShortOpenHashMap c;
        try {
            c = (Float2ShortOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (short[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        short[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeShort(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new float[n];
        float[] key = this.key;
        this.value = new short[n];
        short[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            float k = s.readFloat();
            short v = s.readShort();
            int k2i = HashCommon.float2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                do {
                    if ((h1 += h2) < n && h1 >= 0) continue;
                    h1 -= n;
                } while (state[h1] != 0);
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ShortIterator {
        public short nextShort() {
            return Float2ShortOpenHashMap.this.value[this.nextEntry()];
        }

        public Short next() {
            return Float2ShortOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        public FloatIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Float2ShortOpenHashMap.this.count;
        }

        public boolean contains(float k) {
            return Float2ShortOpenHashMap.this.containsKey(k);
        }

        public boolean remove(float k) {
            int oldCount = Float2ShortOpenHashMap.this.count;
            Float2ShortOpenHashMap.this.remove(k);
            return Float2ShortOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Float2ShortOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        public float nextFloat() {
            return Float2ShortOpenHashMap.this.key[this.nextEntry()];
        }

        public Float next() {
            return Float.valueOf(Float2ShortOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Float2ShortMap.Entry>
    implements Float2ShortMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2ShortMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2ShortMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Float2ShortOpenHashMap.this.findKey(((Float)e.getKey()).floatValue());
            return i >= 0 && Float2ShortOpenHashMap.this.value[i] == (Short)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Float2ShortOpenHashMap.this.findKey(((Float)e.getKey()).floatValue());
            if (i >= 0) {
                Float2ShortOpenHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Float2ShortOpenHashMap.this.count;
        }

        @Override
        public void clear() {
            Float2ShortOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ShortMap.Entry> {
        final AbstractFloat2ShortMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractFloat2ShortMap.BasicEntry(0.0f, 0);
        }

        @Override
        public AbstractFloat2ShortMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2ShortOpenHashMap.this.key[e];
            this.entry.value = Float2ShortOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ShortMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Float2ShortMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Float2ShortOpenHashMap.this.count;
            byte[] state = Float2ShortOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Float2ShortOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Float2ShortOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Float2ShortOpenHashMap.this.state[this.last] = 1;
            --Float2ShortOpenHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Float2ShortMap.Entry,
    Map.Entry<Float, Short> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2ShortOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2ShortOpenHashMap.this.key[this.index];
        }

        @Override
        public Short getValue() {
            return Float2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        public short getShortValue() {
            return Float2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        public short setValue(short v) {
            short oldValue = Float2ShortOpenHashMap.this.value[this.index];
            Float2ShortOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Short setValue(Short v) {
            return this.setValue((short)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2ShortOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2ShortOpenHashMap.this.value[this.index] == (Short)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2ShortOpenHashMap.this.key[this.index]) ^ Float2ShortOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Float2ShortOpenHashMap.this.key[this.index] + "->" + Float2ShortOpenHashMap.this.value[this.index];
        }
    }
}

