/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.IOException;
import java.io.OutputStream;

public class FastByteArrayOutputStream
extends OutputStream
implements RepositionableStream {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public byte[] array;
    public int length;
    private int position;

    public FastByteArrayOutputStream() {
        this(16);
    }

    public FastByteArrayOutputStream(int initialCapacity) {
        this.array = new byte[initialCapacity];
    }

    public FastByteArrayOutputStream(byte[] a) {
        this.array = a;
    }

    public void reset() {
        this.length = 0;
        this.position = 0;
    }

    public void trim() {
        this.array = ByteArrays.trim(this.array, this.length);
    }

    public void write(int b) {
        if (this.position == this.length) {
            ++this.length;
            if (this.position == this.array.length) {
                this.array = ByteArrays.grow(this.array, this.length);
            }
        }
        this.array[this.position++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        ByteArrays.ensureOffsetLength(b, off, len);
        if (this.position + len > this.array.length) {
            this.array = ByteArrays.grow(this.array, this.position + len, this.position);
        }
        System.arraycopy(b, off, this.array, this.position, len);
        if (this.position + len > this.length) {
            this.length = this.position += len;
        }
    }

    public void position(long newPosition) {
        if (this.position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position too large: " + newPosition);
        }
        this.position = (int)newPosition;
    }

    public long position() {
        return this.position;
    }
}

