/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.objects.AbstractObject2ReferenceMap;
import it.unimi.dsi.fastutil.objects.AbstractObject2ReferenceSortedMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2ReferenceLinkedOpenCustomHashMap<K, V>
extends AbstractObject2ReferenceSortedMap<K, V>
implements Serializable,
Cloneable,
Hash {
    protected transient K[] key;
    protected transient V[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Object2ReferenceSortedMap.FastSortedEntrySet<K, V> entries;
    protected volatile transient ObjectSortedSet<K> keys;
    protected volatile transient ReferenceCollection<V> values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    protected Hash.Strategy<K> strategy;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2ReferenceLinkedOpenCustomHashMap(int n, float f, Hash.Strategy<K> strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new Object[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Object2ReferenceLinkedOpenCustomHashMap(int n, Hash.Strategy<K> strategy) {
        this(n, 0.75f, strategy);
    }

    public Object2ReferenceLinkedOpenCustomHashMap(Hash.Strategy<K> strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2ReferenceLinkedOpenCustomHashMap(Map<? extends K, ? extends V> m, float f, Hash.Strategy<K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2ReferenceLinkedOpenCustomHashMap(Map<? extends K, ? extends V> m, Hash.Strategy<K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2ReferenceLinkedOpenCustomHashMap(Object2ReferenceMap<K, V> m, float f, Hash.Strategy<K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2ReferenceLinkedOpenCustomHashMap(Object2ReferenceMap<K, V> m, Hash.Strategy<K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2ReferenceLinkedOpenCustomHashMap(K[] k, V[] v, float f, Hash.Strategy<K> strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2ReferenceLinkedOpenCustomHashMap(K[] k, V[] v, Hash.Strategy<K> strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy<K> strategy() {
        return this.strategy;
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(K k) {
        K[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] != -1 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] == -1 && (key[h1] == HashCommon.REMOVED || h != this.strategy.hashCode(key[h1]) || !this.strategy.equals(k, key[h1])));
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (key[h1] == HashCommon.REMOVED || h != this.strategy.hashCode(key[h1]) || !this.strategy.equals(k, key[h1])) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && (key[h1] == HashCommon.REMOVED || h != this.strategy.hashCode(key[h1]) || !this.strategy.equals(k, key[h1])));
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(K k) {
        K[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] == 0 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && (key[h1] == HashCommon.REMOVED || h != this.strategy.hashCode(key[h1]) || !this.strategy.equals(k, key[h1])));
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public V put(K k, V v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            V oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
        ObjectArrays.fill(this.value, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public K firstKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public Object2ReferenceSortedMap<K, V> tailMap(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2ReferenceSortedMap<K, V> headMap(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2ReferenceSortedMap<K, V> subMap(K from, K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public V get(Object k) {
        int i = this.findKey(k);
        return (V)(i < 0 ? this.defRetValue : this.value[i]);
    }

    @Override
    public V remove(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return (V)this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        V v = this.value[i];
        this.value[i] = null;
        this.fixPointers(i);
        return v;
    }

    public Object2ReferenceSortedMap.FastSortedEntrySet<K, V> object2ReferenceEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ObjectSortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ReferenceCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Object2ReferenceLinkedOpenCustomHashMap.this.count;
                }

                @Override
                public boolean contains(Object v) {
                    return Object2ReferenceLinkedOpenCustomHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Object2ReferenceLinkedOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        K[] key = this.key;
        Object[] newKey = new Object[newN];
        V[] value = this.value;
        Object[] newValue = new Object[newN];
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            K k = key[i];
            V v = value[i];
            int k2i = this.strategy.hashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                do {
                    if ((h1 += h2) < newN && h1 >= 0) continue;
                    h1 -= newN;
                } while (newState[h1] != 0);
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Object2ReferenceLinkedOpenCustomHashMap c;
        try {
            c = (Object2ReferenceLinkedOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            if (this != this.key[i]) {
                t = this.strategy.hashCode(this.key[i]);
            }
            if (this != this.value[i]) {
                t ^= System.identityHashCode(this.value[i]);
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new Object[n];
        Object[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            Object v = s.readObject();
            int k2i = this.strategy.hashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                do {
                    if ((h1 += h2) < n && h1 >= 0) continue;
                    h1 -= n;
                } while (state[h1] != 0);
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends MapIterator
    implements ObjectListIterator<V> {
        @Override
        public V previous() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V next() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractObjectSortedSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator(K from) {
            return new KeyIterator(from);
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.count;
        }

        @Override
        public boolean contains(Object k) {
            return Object2ReferenceLinkedOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldCount = Object2ReferenceLinkedOpenCustomHashMap.this.count;
            Object2ReferenceLinkedOpenCustomHashMap.this.remove(k);
            return Object2ReferenceLinkedOpenCustomHashMap.this.count != oldCount;
        }

        @Override
        public void clear() {
            Object2ReferenceLinkedOpenCustomHashMap.this.clear();
        }

        @Override
        public K first() {
            if (Object2ReferenceLinkedOpenCustomHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Object2ReferenceLinkedOpenCustomHashMap.this.key[Object2ReferenceLinkedOpenCustomHashMap.this.first];
        }

        @Override
        public K last() {
            if (Object2ReferenceLinkedOpenCustomHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Object2ReferenceLinkedOpenCustomHashMap.this.key[Object2ReferenceLinkedOpenCustomHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public final ObjectSortedSet<K> tailSet(K from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> headSet(K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> subSet(K from, K to) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator<K> {
        public KeyIterator(K k) {
            super(k);
        }

        @Override
        public K previous() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K k) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSortedSet<Object2ReferenceMap.Entry<K, V>>
    implements Object2ReferenceSortedMap.FastSortedEntrySet<K, V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Object2ReferenceMap.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Object2ReferenceMap.Entry<K, V>> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Object2ReferenceMap.Entry<K, V>> subSet(Object2ReferenceMap.Entry<K, V> fromElement, Object2ReferenceMap.Entry<K, V> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2ReferenceMap.Entry<K, V>> headSet(Object2ReferenceMap.Entry<K, V> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2ReferenceMap.Entry<K, V>> tailSet(Object2ReferenceMap.Entry<K, V> fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2ReferenceMap.Entry<K, V> first() {
            if (Object2ReferenceLinkedOpenCustomHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2ReferenceLinkedOpenCustomHashMap.this.first);
        }

        @Override
        public Object2ReferenceMap.Entry<K, V> last() {
            if (Object2ReferenceLinkedOpenCustomHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2ReferenceLinkedOpenCustomHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Object2ReferenceLinkedOpenCustomHashMap.this.findKey(e.getKey());
            return i >= 0 && Object2ReferenceLinkedOpenCustomHashMap.this.value[i] == e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Object2ReferenceLinkedOpenCustomHashMap.this.findKey(e.getKey());
            if (i >= 0) {
                Object2ReferenceLinkedOpenCustomHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.count;
        }

        @Override
        public void clear() {
            Object2ReferenceLinkedOpenCustomHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ReferenceMap.Entry<K, V>> iterator(Object2ReferenceMap.Entry<K, V> from) {
            return new EntryIterator(from.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Object2ReferenceMap.Entry<K, V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ReferenceMap.Entry<K, V>> fastIterator(Object2ReferenceMap.Entry<K, V> from) {
            return new FastEntryIterator(from.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ReferenceMap.Entry<K, V>> {
        final AbstractObject2ReferenceMap.BasicEntry<K, V> entry;

        public FastEntryIterator() {
            this.entry = new AbstractObject2ReferenceMap.BasicEntry<Object, Object>(null, null);
        }

        public FastEntryIterator(K from) {
            super(from);
            this.entry = new AbstractObject2ReferenceMap.BasicEntry<Object, Object>(null, null);
        }

        @Override
        public AbstractObject2ReferenceMap.BasicEntry<K, V> next() {
            int e = this.nextEntry();
            this.entry.key = Object2ReferenceLinkedOpenCustomHashMap.this.key[e];
            this.entry.value = Object2ReferenceLinkedOpenCustomHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractObject2ReferenceMap.BasicEntry<K, V> previous() {
            int e = this.previousEntry();
            this.entry.key = Object2ReferenceLinkedOpenCustomHashMap.this.key[e];
            this.entry.value = Object2ReferenceLinkedOpenCustomHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Object2ReferenceMap.Entry<K, V> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ReferenceMap.Entry<K, V> ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ReferenceMap.Entry<K, V>> {
        public EntryIterator() {
        }

        public EntryIterator(K from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Object2ReferenceMap.Entry<K, V> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ReferenceMap.Entry<K, V> ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Object2ReferenceLinkedOpenCustomHashMap.this.first;
        }

        MapIterator(K from) {
            if (Object2ReferenceLinkedOpenCustomHashMap.this.strategy.equals(Object2ReferenceLinkedOpenCustomHashMap.this.key[Object2ReferenceLinkedOpenCustomHashMap.this.last], from)) {
                this.prev = Object2ReferenceLinkedOpenCustomHashMap.this.last;
                this.index = Object2ReferenceLinkedOpenCustomHashMap.this.count;
            } else {
                int e;
                if (!Object2ReferenceLinkedOpenCustomHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Object2ReferenceLinkedOpenCustomHashMap.this.first;
                while (!Object2ReferenceLinkedOpenCustomHashMap.this.strategy.equals(Object2ReferenceLinkedOpenCustomHashMap.this.key[e = this.nextEntry()], from)) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Object2ReferenceLinkedOpenCustomHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Object2ReferenceLinkedOpenCustomHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Object2ReferenceLinkedOpenCustomHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Object2ReferenceLinkedOpenCustomHashMap.this.state[this.curr] = 1;
            Object2ReferenceLinkedOpenCustomHashMap.this.key[this.curr] = HashCommon.REMOVED;
            Object2ReferenceLinkedOpenCustomHashMap.this.value[this.curr] = null;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Object2ReferenceLinkedOpenCustomHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Object2ReferenceLinkedOpenCustomHashMap.this.link[this.curr] ^ this.prev;
            }
            --Object2ReferenceLinkedOpenCustomHashMap.this.count;
            if (this.prev == -1) {
                Object2ReferenceLinkedOpenCustomHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Object2ReferenceLinkedOpenCustomHashMap.this.link[n] = Object2ReferenceLinkedOpenCustomHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Object2ReferenceLinkedOpenCustomHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Object2ReferenceLinkedOpenCustomHashMap.this.link[n] = Object2ReferenceLinkedOpenCustomHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Object2ReferenceMap.Entry<K, V>,
    Map.Entry<K, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Object2ReferenceLinkedOpenCustomHashMap.this.value[this.index];
            Object2ReferenceLinkedOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2ReferenceLinkedOpenCustomHashMap.this.strategy.equals(Object2ReferenceLinkedOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2ReferenceLinkedOpenCustomHashMap.this.value[this.index] == e.getValue();
        }

        @Override
        public int hashCode() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.strategy.hashCode(Object2ReferenceLinkedOpenCustomHashMap.this.key[this.index]) ^ System.identityHashCode(Object2ReferenceLinkedOpenCustomHashMap.this.value[this.index]);
        }

        public String toString() {
            return Object2ReferenceLinkedOpenCustomHashMap.this.key[this.index] + "->" + Object2ReferenceLinkedOpenCustomHashMap.this.value[this.index];
        }
    }
}

