/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.shorts.AbstractShortListIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSortedSet;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortLinkedOpenHashSet
extends AbstractShortSortedSet
implements Serializable,
Cloneable,
Hash {
    protected transient short[] key;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public ShortLinkedOpenHashSet(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new short[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public ShortLinkedOpenHashSet(int n) {
        this(n, 0.75f);
    }

    public ShortLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    public ShortLinkedOpenHashSet(Collection<? extends Short> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ShortLinkedOpenHashSet(Collection<? extends Short> c) {
        this(c, 0.75f);
    }

    public ShortLinkedOpenHashSet(ShortCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ShortLinkedOpenHashSet(ShortCollection c) {
        this(c, 0.75f);
    }

    public ShortLinkedOpenHashSet(ShortIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextShort());
        }
    }

    public ShortLinkedOpenHashSet(ShortIterator i) {
        this(i, 0.75f);
    }

    public ShortLinkedOpenHashSet(Iterator<?> i, float f) {
        this(ShortIterators.asShortIterator(i), f);
    }

    public ShortLinkedOpenHashSet(Iterator<?> i) {
        this(ShortIterators.asShortIterator(i));
    }

    public ShortLinkedOpenHashSet(short[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        ShortArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public ShortLinkedOpenHashSet(short[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public ShortLinkedOpenHashSet(short[] a, float f) {
        this(a, 0, a.length, f);
    }

    public ShortLinkedOpenHashSet(short[] a) {
        this(a, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(short k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        short[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] == -1 && k != key[h1]);
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(short k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        short[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            do {
                if ((h1 += h2) < n && h1 >= 0) continue;
                h1 -= n;
            } while (state[h1] != 0 && k != key[h1]);
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public boolean add(short k) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            return false;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return true;
    }

    @Override
    public boolean remove(short k) {
        int i = this.findKey(k);
        if (i < 0) {
            return false;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return true;
    }

    @Override
    public boolean contains(short k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public short firstShort() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public short lastShort() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ShortSortedSet tailSet(short from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShortSortedSet headSet(short to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShortSortedSet subSet(short from, short to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ShortComparator comparator() {
        return null;
    }

    @Override
    public ShortBidirectionalIterator iterator(short from) {
        return new SetIterator(from);
    }

    @Override
    public ShortBidirectionalIterator iterator() {
        return new SetIterator();
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        short[] key = this.key;
        short[] newKey = new short[newN];
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            short k = key[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            if (newState[h1] != 0) {
                int h2 = k2i % (newN - 2) + 1;
                do {
                    if ((h1 += h2) < newN && h1 >= 0) continue;
                    h1 -= newN;
                } while (newState[h1] != 0);
            }
            newState[h1] = -1;
            newKey[h1] = k;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object clone() {
        ShortLinkedOpenHashSet c;
        try {
            c = (ShortLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (short[])this.key.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            h += this.key[i];
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ShortBidirectionalIterator i = this.iterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            s.writeShort(i.nextShort());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new short[n];
        short[] key = this.key;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            short k = s.readShort();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                do {
                    if ((h1 += h2) < n && h1 >= 0) continue;
                    h1 -= n;
                } while (state[h1] != 0);
            }
            state[h1] = -1;
            key[h1] = k;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractShortListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        SetIterator() {
            this.next = ShortLinkedOpenHashSet.this.first;
        }

        SetIterator(short from) {
            if (ShortLinkedOpenHashSet.this.key[ShortLinkedOpenHashSet.this.last] == from) {
                this.prev = ShortLinkedOpenHashSet.this.last;
                this.index = ShortLinkedOpenHashSet.this.count;
            } else {
                short k;
                if (!ShortLinkedOpenHashSet.this.contains(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = ShortLinkedOpenHashSet.this.first;
                while ((k = this.nextShort()) != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = ShortLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return ShortLinkedOpenHashSet.this.key[this.curr];
        }

        public short previousShort() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = ShortLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return ShortLinkedOpenHashSet.this.key[this.curr];
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            ShortLinkedOpenHashSet.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = ShortLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            } else {
                this.next = ShortLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            }
            --ShortLinkedOpenHashSet.this.count;
            if (this.prev == -1) {
                ShortLinkedOpenHashSet.this.first = this.next;
            } else {
                int n = this.prev;
                ShortLinkedOpenHashSet.this.link[n] = ShortLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                ShortLinkedOpenHashSet.this.last = this.prev;
            } else {
                int n = this.next;
                ShortLinkedOpenHashSet.this.link[n] = ShortLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }
    }
}

