/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax;

import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeatureFactory;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeatureJob;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeature;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeatureFactory;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeatureFactory;
import edu.jhu.thrax.hadoop.jobs.DistributionalContextExtractionJob;
import edu.jhu.thrax.hadoop.jobs.DistributionalContextSortingJob;
import edu.jhu.thrax.hadoop.jobs.ExtractionJob;
import edu.jhu.thrax.hadoop.jobs.FeatureCollectionJob;
import edu.jhu.thrax.hadoop.jobs.JobState;
import edu.jhu.thrax.hadoop.jobs.OutputJob;
import edu.jhu.thrax.hadoop.jobs.ParaphraseAggregationJob;
import edu.jhu.thrax.hadoop.jobs.ParaphrasePivotingJob;
import edu.jhu.thrax.hadoop.jobs.Scheduler;
import edu.jhu.thrax.hadoop.jobs.SchedulerException;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import edu.jhu.thrax.hadoop.jobs.VocabularyJob;
import edu.jhu.thrax.util.BackwardsCompatibility;
import edu.jhu.thrax.util.ConfFileParser;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Thrax
extends Configured
implements Tool {
    private Scheduler scheduler;
    private Configuration conf;

    public synchronized int run(String[] argv) throws Exception {
        if (argv.length < 1) {
            System.err.println("usage: Thrax <conf file> [output path]");
            return 1;
        }
        this.conf = this.getConf();
        Map<String, String> options = ConfFileParser.parse(argv[0]);
        for (String opt : options.keySet()) {
            this.conf.set("thrax." + opt, options.get(opt));
        }
        String date = new Date().toString().replaceAll("\\s+", "_").replaceAll(":", "_");
        String workDir = "thrax_run_" + date + "/";
        if (argv.length > 1 && !(workDir = argv[1]).endsWith("/")) {
            workDir = workDir + "/";
        }
        this.conf.set("thrax.work-dir", workDir);
        this.conf.set("thrax.outputPath", workDir + "final");
        if (options.containsKey("timeout")) {
            this.conf.setInt("mapreduce.task.timeout", Integer.parseInt(options.get("timeout")));
            this.conf.setInt("mapred.task.timeout", Integer.parseInt(options.get("timeout")));
        }
        this.scheduleJobs();
        do {
            for (Class<? extends ThraxJob> c : this.scheduler.getClassesByState(JobState.READY)) {
                this.scheduler.setState(c, JobState.RUNNING);
                new Thread(new ThraxJobWorker(this, c, this.conf)).start();
            }
            ((Object)((Object)this)).wait();
        } while (this.scheduler.notFinished());
        System.err.print(this.scheduler);
        if (this.scheduler.getClassesByState(JobState.SUCCESS).size() == this.scheduler.numJobs()) {
            System.err.println("Work directory was " + workDir);
            System.err.println("To retrieve grammar:");
            System.err.println("hadoop fs -getmerge " + this.conf.get("thrax.outputPath", "") + " <destination>");
        }
        return 0;
    }

    private synchronized void scheduleJobs() throws SchedulerException {
        this.scheduler = new Scheduler(this.conf);
        String type = this.conf.get("thrax.type", "translation");
        String features = BackwardsCompatibility.equivalent(this.conf.get("thrax.features", ""));
        System.err.println("Running in mode: " + type);
        this.scheduler.schedule(VocabularyJob.class);
        if ("translation".equals(type)) {
            this.scheduler.schedule(ExtractionJob.class);
            for (MapReduceFeature f : MapReduceFeatureFactory.getAll(features)) {
                this.scheduler.schedule(f.getClass());
                OutputJob.addPrerequisite(f.getClass());
            }
            List<AnnotationFeature> annotation_features = AnnotationFeatureFactory.getAll(features);
            for (AnnotationFeature f : annotation_features) {
                AnnotationFeatureJob.addPrerequisites(f.getPrerequisites());
            }
            if (!annotation_features.isEmpty()) {
                this.scheduler.schedule(AnnotationFeatureJob.class);
                OutputJob.addPrerequisite(AnnotationFeatureJob.class);
            }
            this.scheduler.schedule(OutputJob.class);
            this.scheduler.percolate(OutputJob.class);
        } else if ("paraphrasing".equals(type)) {
            this.scheduler.schedule(ExtractionJob.class);
            HashSet<String> prereq_features = new HashSet<String>();
            List<PivotedFeature> pivoted_features = PivotedFeatureFactory.getAll(features);
            for (PivotedFeature pf : pivoted_features) {
                prereq_features.addAll(pf.getPrerequisites());
            }
            boolean annotation_features = false;
            for (String f_name : prereq_features) {
                MapReduceFeature mf = MapReduceFeatureFactory.get(f_name);
                if (mf != null) {
                    this.scheduler.schedule(mf.getClass());
                    FeatureCollectionJob.addPrerequisite(mf.getClass());
                    continue;
                }
                AnnotationFeature af = AnnotationFeatureFactory.get(f_name);
                if (af == null) continue;
                AnnotationFeatureJob.addPrerequisites(af.getPrerequisites());
                annotation_features = true;
            }
            if (annotation_features) {
                this.scheduler.schedule(AnnotationFeatureJob.class);
                FeatureCollectionJob.addPrerequisite(AnnotationFeatureJob.class);
            }
            this.scheduler.schedule(FeatureCollectionJob.class);
            this.scheduler.schedule(ParaphrasePivotingJob.class);
            this.scheduler.schedule(ParaphraseAggregationJob.class);
            this.scheduler.percolate(ParaphraseAggregationJob.class);
        } else if ("distributional".equals(type)) {
            this.scheduler.schedule(DistributionalContextExtractionJob.class);
            this.scheduler.schedule(DistributionalContextSortingJob.class);
            this.scheduler.percolate(DistributionalContextSortingJob.class);
        } else {
            System.err.println("Unknown grammar type. No jobs scheduled.");
        }
    }

    public static void main(String[] argv) throws Exception {
        ToolRunner.run(null, (Tool)new Thrax(), (String[])argv);
    }

    protected synchronized void workerDone(Class<? extends ThraxJob> theClass, boolean success) {
        try {
            this.scheduler.setState(theClass, success ? JobState.SUCCESS : JobState.FAILED);
        }
        catch (SchedulerException e) {
            System.err.println(e.getMessage());
        }
        ((Object)((Object)this)).notify();
    }

    public class ThraxJobWorker
    implements Runnable {
        private Thrax thrax;
        private Class<? extends ThraxJob> theClass;

        public ThraxJobWorker(Thrax t, Class<? extends ThraxJob> c, Configuration conf) {
            this.thrax = t;
            this.theClass = c;
        }

        @Override
        public void run() {
            try {
                ThraxJob thraxJob = this.theClass.newInstance();
                Job job = thraxJob.getJob(Thrax.this.conf);
                job.waitForCompletion(false);
                this.thrax.workerDone(this.theClass, job.isSuccessful());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.thrax.workerDone(this.theClass, false);
            }
        }
    }
}

