/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.datatypes;

import edu.jhu.thrax.datatypes.Alignment;
import edu.jhu.thrax.datatypes.AlignmentIterator;
import edu.jhu.thrax.datatypes.IntPair;
import edu.jhu.thrax.util.FormatUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ArrayAlignment
implements Alignment {
    private final int[] sourceIndicesInOrder;
    private final int[] targetIndicesSourceOrder;
    private final int[] targetIndicesInOrder;
    private final int[] sourceIndicesTargetOrder;

    private ArrayAlignment(List<IntPair> pairs, boolean reverse) {
        int[] sortedCars = ArrayAlignment.cars(pairs);
        int[] cdrs = ArrayAlignment.cdrs(pairs);
        List<IntPair> reversedPairs = ArrayAlignment.reverseAll(pairs);
        Collections.sort(reversedPairs);
        int[] sortedCdrs = ArrayAlignment.cars(reversedPairs);
        int[] cars = ArrayAlignment.cdrs(reversedPairs);
        if (!reverse) {
            this.sourceIndicesInOrder = sortedCars;
            this.targetIndicesSourceOrder = cdrs;
            this.targetIndicesInOrder = sortedCdrs;
            this.sourceIndicesTargetOrder = cars;
        } else {
            this.sourceIndicesInOrder = sortedCdrs;
            this.targetIndicesSourceOrder = cars;
            this.targetIndicesInOrder = sortedCars;
            this.sourceIndicesTargetOrder = cdrs;
        }
    }

    public static ArrayAlignment fromString(String s, boolean reverse) {
        String[] tokens = FormatUtils.P_SPACE.split(s);
        List<IntPair> pairs = ArrayAlignment.getIntPairsFromTokens(tokens);
        Collections.sort(pairs);
        return new ArrayAlignment(pairs, reverse);
    }

    @Override
    public boolean consistentWith(int sourceLength, int targetLength) {
        if (this.sourceIndicesInOrder.length == 0) {
            return true;
        }
        return this.sourceIndicesInOrder[0] >= 0 && this.targetIndicesInOrder[0] >= 0 && this.sourceIndicesInOrder[this.sourceIndicesInOrder.length - 1] < sourceLength && this.targetIndicesInOrder[this.targetIndicesInOrder.length - 1] < targetLength;
    }

    @Override
    public boolean sourceIndexIsAligned(int i) {
        return Arrays.binarySearch(this.sourceIndicesInOrder, i) >= 0;
    }

    @Override
    public boolean targetIndexIsAligned(int i) {
        return Arrays.binarySearch(this.targetIndicesInOrder, i) >= 0;
    }

    @Override
    public int numTargetWordsAlignedTo(int i) {
        return ArrayAlignment.frequency(this.sourceIndicesInOrder, i);
    }

    @Override
    public int numSourceWordsAlignedTo(int i) {
        return ArrayAlignment.frequency(this.targetIndicesInOrder, i);
    }

    @Override
    public Iterator<Integer> targetIndicesAlignedTo(int i) {
        int start = ArrayAlignment.firstIndexOf(this.sourceIndicesInOrder, i);
        if (start < 0) {
            return Collections.emptyList().iterator();
        }
        return new AlignmentIterator(this.sourceIndicesInOrder, this.targetIndicesSourceOrder, i, start);
    }

    @Override
    public Iterator<Integer> sourceIndicesAlignedTo(int i) {
        int start = ArrayAlignment.firstIndexOf(this.targetIndicesInOrder, i);
        if (start < 0) {
            return Collections.emptyList().iterator();
        }
        return new AlignmentIterator(this.targetIndicesInOrder, this.sourceIndicesTargetOrder, i, start);
    }

    public byte[] toCompactSourceArray() {
        byte[] result = new byte[this.sourceIndicesInOrder.length * 2];
        for (int i = 0; i < this.sourceIndicesInOrder.length; ++i) {
            result[i * 2] = (byte)this.sourceIndicesInOrder[i];
            result[i * 2 + 1] = (byte)this.targetIndicesSourceOrder[i];
        }
        return result;
    }

    public byte[] toCompactTargetArray() {
        byte[] result = new byte[this.targetIndicesInOrder.length * 2];
        for (int i = 0; i < this.targetIndicesInOrder.length; ++i) {
            result[i * 2] = (byte)this.targetIndicesInOrder[i];
            result[i * 2 + 1] = (byte)this.sourceIndicesTargetOrder[i];
        }
        return result;
    }

    private static int[] cars(List<IntPair> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get((int)i).fst;
        }
        return result;
    }

    private static int[] cdrs(List<IntPair> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get((int)i).snd;
        }
        return result;
    }

    private static List<IntPair> reverseAll(List<IntPair> list) {
        ArrayList<IntPair> result = new ArrayList<IntPair>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            result.add(i, list.get(i).reverse());
        }
        return result;
    }

    private static List<IntPair> getIntPairsFromTokens(String[] toks) {
        ArrayList<IntPair> result = new ArrayList<IntPair>();
        for (String t : toks) {
            IntPair ip = IntPair.fromHyphenatedString(t);
            if (ip == null) continue;
            result.add(ip);
        }
        return result;
    }

    private static int firstIndexOf(int[] array, int key) {
        int index = Arrays.binarySearch(array, key);
        if (index < 0) {
            return index;
        }
        while (index >= 0 && array[index] == key) {
            --index;
        }
        return index + 1;
    }

    private static int lastIndexOf(int[] array, int key) {
        int index = Arrays.binarySearch(array, key);
        if (index < 0) {
            return index;
        }
        while (index < array.length && array[index] == key) {
            ++index;
        }
        return index;
    }

    private static int frequency(int[] array, int key) {
        int start = ArrayAlignment.firstIndexOf(array, key);
        if (start < 0) {
            return 0;
        }
        int end = ArrayAlignment.lastIndexOf(array, key);
        return end - start;
    }
}

