/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.datatypes;

import edu.jhu.thrax.datatypes.Alignment;
import edu.jhu.thrax.datatypes.PhrasePair;
import edu.jhu.thrax.extraction.SpanLabeler;
import edu.jhu.thrax.util.Vocabulary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class HierarchicalRule {
    private final PhrasePair lhs;
    private final PhrasePair[] nts;
    private static final PhrasePair[] EMPTY_NT_ARRAY = new PhrasePair[0];

    public HierarchicalRule(PhrasePair left_hand_side, PhrasePair[] nonterms) {
        this.lhs = left_hand_side;
        this.nts = nonterms;
    }

    public HierarchicalRule(PhrasePair leftHandSide) {
        this(leftHandSide, EMPTY_NT_ARRAY);
    }

    public int arity() {
        return this.nts.length;
    }

    public int numSourceTerminals() {
        int result = this.lhs.sourceLength();
        for (PhrasePair pp : this.nts) {
            result -= pp.sourceLength();
        }
        return result;
    }

    public int numTargetTerminals() {
        int result = this.lhs.targetLength();
        for (PhrasePair pp : this.nts) {
            result -= pp.targetLength();
        }
        return result;
    }

    public int numAlignmentPoints(Alignment a) {
        int result = this.lhs.numAlignmentPoints(a);
        for (PhrasePair pp : this.nts) {
            result -= pp.numAlignmentPoints(a);
        }
        return result;
    }

    public PhrasePair getLhs() {
        return this.lhs;
    }

    public PhrasePair getNonterminal(int index) {
        if (index < 0 || index > this.nts.length) {
            return null;
        }
        return this.nts[index];
    }

    public HierarchicalRule addNonterminal(PhrasePair pp) {
        PhrasePair[] theNTs = new PhrasePair[this.nts.length + 1];
        for (int i = 0; i < this.nts.length; ++i) {
            theNTs[i] = this.nts[i];
        }
        theNTs[this.nts.length] = pp;
        return new HierarchicalRule(this.lhs, theNTs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HierarchicalRule { ");
        sb.append(String.format("lhs:%s ", this.lhs));
        for (int i = 0; i < this.nts.length; ++i) {
            sb.append(String.format("%d:%s ", i, this.nts[i]));
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString(int[] source, int[] target, SpanLabeler labeler, boolean source_labels) {
        return Vocabulary.word(this.lhsLabel(labeler, source_labels)) + " ||| " + Vocabulary.getWords(this.sourceSide(source, labeler, source_labels)) + " ||| " + Vocabulary.getWords(this.targetSide(target, labeler, source_labels));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HierarchicalRule)) {
            return false;
        }
        HierarchicalRule other = (HierarchicalRule)o;
        return this.lhs.equals(other.lhs) && Arrays.equals(this.nts, other.nts);
    }

    public int hashCode() {
        int result = 137;
        result = result * 37 + this.lhs.hashCode();
        result = result * 37 + Arrays.hashCode(this.nts);
        return result;
    }

    public int lhsLabel(SpanLabeler labeler, boolean use_source) {
        return this.lhs.getLabel(labeler, use_source);
    }

    private int ntLabel(int i, SpanLabeler labeler, boolean use_source) {
        if (i < 0 || i >= this.nts.length) {
            return 0;
        }
        return this.nts[i].getLabel(labeler, use_source);
    }

    public int[] sourceSide(int[] source, SpanLabeler labeler, boolean use_source) {
        int[] result = new int[this.numSourceTerminals() + this.nts.length];
        int n = 0;
        int j = 0;
        for (int i = this.lhs.sourceStart; i < this.lhs.sourceEnd; ++i) {
            if (n < this.nts.length && i == this.nts[n].sourceStart) {
                result[j] = this.ntLabel(n, labeler, use_source);
                i = this.nts[n].sourceEnd - 1;
                ++n;
            } else {
                result[j] = source[i];
            }
            ++j;
        }
        return result;
    }

    public int[] targetSide(int[] target, SpanLabeler labeler, boolean use_source) {
        int[] result = new int[this.numTargetTerminals() + this.nts.length];
        int j = 0;
        for (int i = this.lhs.targetStart; i < this.lhs.targetEnd; ++i) {
            boolean nt = false;
            for (int n = 0; n < this.nts.length; ++n) {
                if (i != this.nts[n].targetStart) continue;
                result[j] = this.ntLabel(n, labeler, use_source);
                i = this.nts[n].targetEnd - 1;
                nt = true;
                break;
            }
            if (!nt) {
                result[j] = target[i];
            }
            ++j;
        }
        return result;
    }

    private int[] sourceToRule() {
        int[] result = new int[this.lhs.sourceEnd - this.lhs.sourceStart];
        int current = 0;
        int n = 0;
        for (int i = this.lhs.sourceStart; i < this.lhs.sourceEnd; ++i) {
            if (n < this.nts.length && i == this.nts[n].sourceStart) {
                i = this.nts[n].sourceEnd - 1;
                ++n;
            } else {
                result[i - this.lhs.sourceStart] = current;
            }
            ++current;
        }
        return result;
    }

    private int[] targetToRule() {
        int[] result = new int[this.lhs.targetEnd - this.lhs.targetStart];
        int current = 0;
        for (int i = this.lhs.targetStart; i < this.lhs.targetEnd; ++i) {
            boolean nt = false;
            for (int j = 0; j < this.arity(); ++j) {
                if (i != this.nts[j].targetStart) continue;
                i = this.nts[j].targetEnd - 1;
                nt = true;
                break;
            }
            if (!nt) {
                result[i - this.lhs.targetStart] = current;
            }
            ++current;
        }
        return result;
    }

    public byte[] compactSourceAlignment(Alignment a) {
        int[] src_to_rule = this.sourceToRule();
        int[] tgt_to_rule = this.targetToRule();
        ArrayList<Byte> points = new ArrayList<Byte>();
        int n = 0;
        for (int i = this.lhs.sourceStart; i < this.lhs.sourceEnd; ++i) {
            if (n < this.nts.length && i == this.nts[n].sourceStart) {
                i = this.nts[n++].sourceEnd - 1;
                continue;
            }
            Iterator<Integer> aligned = a.targetIndicesAlignedTo(i);
            while (aligned.hasNext()) {
                points.add((byte)src_to_rule[i - this.lhs.sourceStart]);
                points.add((byte)tgt_to_rule[aligned.next() - this.lhs.targetStart]);
            }
        }
        byte[] result = new byte[points.size()];
        int i = 0;
        Iterator i$ = points.iterator();
        while (i$.hasNext()) {
            byte b = (Byte)i$.next();
            result[i++] = b;
        }
        return result;
    }

    public byte[] compactTargetAlignment(Alignment a) {
        int[] tgt_to_rule = this.targetToRule();
        int[] src_to_rule = this.sourceToRule();
        ArrayList<Byte> points = new ArrayList<Byte>();
        for (int i = this.lhs.targetStart; i < this.lhs.targetEnd; ++i) {
            boolean nt = false;
            for (int n = 0; n < this.nts.length; ++n) {
                if (i != this.nts[n].targetStart) continue;
                i = this.nts[n].targetEnd - 1;
                nt = true;
                break;
            }
            if (nt) continue;
            Iterator<Integer> aligned = a.sourceIndicesAlignedTo(i);
            while (aligned.hasNext()) {
                points.add((byte)tgt_to_rule[i - this.lhs.targetStart]);
                points.add((byte)src_to_rule[aligned.next() - this.lhs.sourceStart]);
            }
        }
        byte[] result = new byte[points.size()];
        int i = 0;
        Iterator i$ = points.iterator();
        while (i$.hasNext()) {
            byte b = (Byte)i$.next();
            result[i++] = b;
        }
        return result;
    }

    public boolean monotonic() {
        if (this.nts.length < 2) {
            return true;
        }
        return this.nts[0].targetEnd <= this.nts[1].targetStart;
    }
}

