/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.datatypes;

import edu.jhu.thrax.util.FormatUtils;

public class IntPair
implements Comparable<IntPair> {
    public final int fst;
    public final int snd;

    public IntPair(int a, int b) {
        this.fst = a;
        this.snd = b;
    }

    public IntPair reverse() {
        return new IntPair(this.snd, this.fst);
    }

    public static IntPair fromHyphenatedString(String s) {
        String[] nums = FormatUtils.P_DASH.split(s);
        if (nums.length != 2) {
            return null;
        }
        return new IntPair(Integer.parseInt(nums[0]), Integer.parseInt(nums[1]));
    }

    public String toString() {
        return String.format("(%d,%d)", this.fst, this.snd);
    }

    public boolean equals(Object o) {
        if (o instanceof IntPair) {
            IntPair ip = (IntPair)o;
            return this.fst == ip.fst && this.snd == ip.snd;
        }
        return false;
    }

    @Override
    public int compareTo(IntPair ip) {
        if (this.fst == ip.fst) {
            return this.snd - ip.snd;
        }
        return this.fst - ip.fst;
    }

    public int hashCode() {
        return this.fst * 37 + this.snd;
    }
}

