/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.datatypes;

import edu.jhu.thrax.datatypes.Alignment;
import edu.jhu.thrax.extraction.SpanLabeler;
import java.util.Iterator;

public class PhrasePair {
    public final int sourceStart;
    public final int sourceEnd;
    public final int targetStart;
    public final int targetEnd;

    public PhrasePair(int ss, int se, int ts, int te) {
        this.sourceStart = ss;
        this.sourceEnd = se;
        this.targetStart = ts;
        this.targetEnd = te;
    }

    public boolean contains(PhrasePair other) {
        return other.sourceStart >= this.sourceStart && other.sourceEnd <= this.sourceEnd && other.targetStart >= this.targetStart && other.targetEnd <= this.targetEnd;
    }

    public boolean isInitialPhrasePair(Alignment a, boolean allowUnaligned, int minimumAligned) {
        int numLinks = 0;
        for (int i = this.sourceStart; i < this.sourceEnd; ++i) {
            Iterator<Integer> js = a.targetIndicesAlignedTo(i);
            while (js.hasNext()) {
                ++numLinks;
                int j = js.next();
                if (j >= this.targetStart && j < this.targetEnd) continue;
                return false;
            }
        }
        for (int j = this.targetStart; j < this.targetEnd; ++j) {
            Iterator<Integer> is = a.sourceIndicesAlignedTo(j);
            while (is.hasNext()) {
                ++numLinks;
                int i = is.next();
                if (i >= this.sourceStart && i < this.sourceEnd) continue;
                return false;
            }
        }
        return numLinks >= minimumAligned && (allowUnaligned || this.isMinimal(a));
    }

    private boolean isMinimal(Alignment a) {
        return a.sourceIndexIsAligned(this.sourceStart) && a.sourceIndexIsAligned(this.sourceEnd - 1) && a.targetIndexIsAligned(this.targetStart) && a.targetIndexIsAligned(this.targetEnd - 1);
    }

    public int sourceLength() {
        return this.sourceEnd - this.sourceStart;
    }

    public int targetLength() {
        return this.targetEnd - this.targetStart;
    }

    public int numAlignmentPoints(Alignment a) {
        if (this.sourceLength() < this.targetLength()) {
            return this.countAlignmentPointsSource(a);
        }
        return this.countAlignmentPointsTarget(a);
    }

    private int countAlignmentPointsSource(Alignment a) {
        int result = 0;
        for (int i = this.sourceStart; i < this.sourceEnd; ++i) {
            result += a.numTargetWordsAlignedTo(i);
        }
        return result;
    }

    private int countAlignmentPointsTarget(Alignment a) {
        int result = 0;
        for (int j = this.targetStart; j < this.targetEnd; ++j) {
            result += a.numSourceWordsAlignedTo(j);
        }
        return result;
    }

    public String toString() {
        return String.format("[%d,%d)+[%d,%d)", this.sourceStart, this.sourceEnd, this.targetStart, this.targetEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhrasePair)) {
            return false;
        }
        PhrasePair p = (PhrasePair)o;
        return this.sourceStart == p.sourceStart && this.sourceEnd == p.sourceEnd && this.targetStart == p.targetStart && this.targetEnd == p.targetEnd;
    }

    public int hashCode() {
        int result = 37;
        result *= 163 + this.sourceStart;
        result *= 163 + this.sourceEnd;
        result *= 163 + this.targetStart;
        return result *= 163 + this.targetEnd;
    }

    public int getLabel(SpanLabeler labeler, boolean useSource) {
        if (useSource) {
            return labeler.getLabel(this.sourceStart, this.sourceEnd);
        }
        return labeler.getLabel(this.targetStart, this.targetEnd);
    }

    public boolean sourceIsDisjointFrom(PhrasePair other) {
        if (other.sourceStart < this.sourceStart) {
            return other.sourceEnd <= this.sourceStart;
        }
        return other.sourceStart >= this.sourceEnd;
    }

    public boolean targetIsDisjointFrom(PhrasePair other) {
        if (other.targetStart < this.targetStart) {
            return other.targetEnd <= this.targetStart;
        }
        return other.targetStart >= this.targetEnd;
    }
}

