/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.distributional;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ContextPhrase {
    private final Text phrase;
    private MapWritable features;

    public ContextPhrase(String phrase) {
        this.phrase = new Text(phrase);
        this.features = new MapWritable();
    }

    public void addFeature(String feature_name) {
        this.addFeature(feature_name, 1);
    }

    public void addFeature(String feature_name, int feature_value) {
        Text feature_text = new Text(feature_name);
        Writable current_value = this.features.get((Object)feature_text);
        if (current_value != null) {
            this.features.put((Writable)feature_text, (Writable)new IntWritable(((IntWritable)current_value).get() + feature_value));
        } else {
            this.features.put((Writable)feature_text, (Writable)new IntWritable(feature_value));
        }
    }

    public Text getPhrase() {
        return this.phrase;
    }

    public MapWritable getFeatures() {
        return this.features;
    }
}

