/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.distributional;

import java.util.HashMap;
import java.util.Map;

public class FeatureTypes {

    public static enum Flavor {
        NONE(0, "none"),
        GOV(1, "gov"),
        DEP(2, "dep"),
        HEAD(3, "head");

        public final int code;
        public final String name;

        private Flavor(int code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    public static enum Directionality {
        NONE(0, "none"),
        LEFT(1, "left"),
        RIGHT(2, "right"),
        CENTER(3, "center");

        public final int code;
        public final String name;

        private Directionality(int code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    public static enum Label {
        NONE(0, "none"),
        LEX(1, "lex"),
        LEM(2, "lem"),
        POS(3, "pos"),
        NER(4, "ner");

        public final int code;
        public final String name;

        private Label(int code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    public static enum Type {
        NGRAM(0, "ngram"),
        SYN(1, "syn"),
        DEP(2, "dep"),
        CDEP(3, "cdep"),
        CPDEP(4, "cpdep");

        private static Map<Integer, Type> map;
        public final int code;
        public final String name;

        public static Type get(int code) {
            return map.get(code);
        }

        private Type(int code, String name) {
            this.code = code;
            this.name = name;
        }

        static {
            map = new HashMap<Integer, Type>();
            for (Type t : Type.values()) {
                map.put(t.code, t);
            }
        }
    }
}

