/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.extraction;

import edu.jhu.thrax.datatypes.Alignment;
import edu.jhu.thrax.datatypes.ArrayAlignment;
import edu.jhu.thrax.datatypes.HierarchicalRule;
import edu.jhu.thrax.datatypes.PhrasePair;
import edu.jhu.thrax.extraction.HieroLabeler;
import edu.jhu.thrax.util.FormatUtils;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class HierarchicalRuleExtractor {
    private int arityLimit = 2;
    private int initialPhraseSourceLimit = 10;
    private int initialPhraseTargetLimit = 10;
    private boolean requireMinimalPhrases = true;
    private int minimumInitialAlignmentPoints = 1;
    private boolean allowAdjacent = false;
    private int sourceSymbolLimit = 5;
    private int targetSymbolLimit = 1000;
    private int minimumRuleAlignmentPoints = 1;
    private int lexicalRuleSourceLimit = 10;
    private int lexicalRuleTargetLimit = 10;
    private boolean allowAbstract = false;
    private boolean allowMixed = true;
    private boolean allowFullSentenceRules = true;
    private PhrasePair fullSentencePhrasePair;

    public HierarchicalRuleExtractor() {
    }

    public HierarchicalRuleExtractor(int arity, int initialPhraseSource, int initialPhraseTarget, int initialAlignment, boolean initialAligned, int sourceLimit, int targetLimit, int ruleAlignment, boolean adjacent, boolean allow_abstract, boolean allow_mixed, boolean allowFullSentence, int lexSourceLimit, int lexTargetLimit) {
        this.arityLimit = arity;
        this.initialPhraseSourceLimit = initialPhraseSource;
        this.initialPhraseTargetLimit = initialPhraseTarget;
        this.minimumInitialAlignmentPoints = initialAlignment;
        this.requireMinimalPhrases = initialAligned;
        this.sourceSymbolLimit = sourceLimit;
        this.targetSymbolLimit = targetLimit;
        this.minimumRuleAlignmentPoints = ruleAlignment;
        this.lexicalRuleSourceLimit = lexSourceLimit;
        this.lexicalRuleTargetLimit = lexTargetLimit;
        this.allowAdjacent = adjacent;
        this.allowAbstract = allow_abstract;
        this.allowMixed = allow_mixed;
        this.allowFullSentenceRules = allowFullSentence;
    }

    public List<HierarchicalRule> extract(int sourceLength, int targetLength, Alignment alignment) {
        this.fullSentencePhrasePair = new PhrasePair(0, sourceLength, 0, targetLength);
        List<PhrasePair> initialPhrasePairs = this.initialPhrasePairs(sourceLength, targetLength, alignment);
        HierarchicalRule[][] rulesByArity = new HierarchicalRule[this.arityLimit + 1][];
        rulesByArity[0] = new HierarchicalRule[initialPhrasePairs.size()];
        for (int i = 0; i < initialPhrasePairs.size(); ++i) {
            rulesByArity[0][i] = new HierarchicalRule(initialPhrasePairs.get(i));
        }
        for (int j = 1; j <= this.arityLimit; ++j) {
            rulesByArity[j] = this.addNonterminalsTo(rulesByArity[j - 1], initialPhrasePairs);
        }
        return this.removeIfNotValid(rulesByArity, alignment);
    }

    private List<PhrasePair> initialPhrasePairs(int sourceLength, int targetLength, Alignment a) {
        ArrayList<PhrasePair> result = new ArrayList<PhrasePair>();
        for (int i = 0; i < sourceLength; ++i) {
            for (int x = 1; x <= this.initialPhraseSourceLimit && i + x <= sourceLength; ++x) {
                for (int j = 0; j < targetLength; ++j) {
                    for (int y = 1; y <= this.initialPhraseTargetLimit && j + y <= targetLength; ++y) {
                        PhrasePair pp = new PhrasePair(i, i + x, j, j + y);
                        if (!pp.isInitialPhrasePair(a, !this.requireMinimalPhrases, this.minimumInitialAlignmentPoints)) continue;
                        result.add(pp);
                    }
                }
            }
            if (i != 0 || !this.allowFullSentenceRules || result.contains(this.fullSentencePhrasePair)) continue;
            result.add(this.fullSentencePhrasePair);
        }
        return result;
    }

    private HierarchicalRule[] addNonterminalsTo(HierarchicalRule[] rules, List<PhrasePair> initialPhrasePairs) {
        ArrayList<HierarchicalRule> result = new ArrayList<HierarchicalRule>();
        block0: for (HierarchicalRule r : rules) {
            int start = HierarchicalRuleExtractor.getStart(r, this.allowAdjacent);
            int end = r.getLhs().sourceEnd;
            for (PhrasePair pp : initialPhrasePairs) {
                if (pp.sourceStart < start) continue;
                if (pp.sourceStart >= end) continue block0;
                if (!r.getLhs().contains(pp)) continue;
                boolean disjointFromAllNTs = true;
                for (int i = 0; i < r.arity(); ++i) {
                    if (r.getNonterminal(i).targetIsDisjointFrom(pp)) continue;
                    disjointFromAllNTs = false;
                    break;
                }
                if (!disjointFromAllNTs) continue;
                result.add(r.addNonterminal(pp));
            }
        }
        HierarchicalRule[] resultArray = new HierarchicalRule[result.size()];
        return result.toArray(resultArray);
    }

    private static int getStart(HierarchicalRule r, boolean allowAdjacent) {
        int arity = r.arity();
        if (arity == 0) {
            return r.getLhs().sourceStart;
        }
        int start = r.getNonterminal((int)(arity - 1)).sourceEnd;
        int offset = allowAdjacent ? 0 : 1;
        return start + offset;
    }

    private List<HierarchicalRule> removeIfNotValid(HierarchicalRule[][] rules, Alignment a) {
        ArrayList<HierarchicalRule> result = new ArrayList<HierarchicalRule>();
        HierarchicalRule[][] arr$ = rules;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HierarchicalRule[] rs;
            for (HierarchicalRule r : rs = arr$[i$]) {
                if (!this.isValid(r, a)) continue;
                result.add(r);
            }
        }
        return result;
    }

    private boolean isValid(HierarchicalRule r, Alignment a) {
        int arity = r.arity();
        int numSourceTerminals = r.numSourceTerminals();
        int numTargetTerminals = r.numTargetTerminals();
        if (arity > 0) {
            if (arity + numSourceTerminals > this.sourceSymbolLimit) {
                return false;
            }
            if (arity + numTargetTerminals > this.targetSymbolLimit) {
                return false;
            }
        } else {
            if (numSourceTerminals > this.lexicalRuleSourceLimit) {
                return false;
            }
            if (numTargetTerminals > this.lexicalRuleTargetLimit) {
                return false;
            }
        }
        if (r.numAlignmentPoints(a) < this.minimumRuleAlignmentPoints) {
            return false;
        }
        if (!this.allowAbstract && numSourceTerminals == 0 && numTargetTerminals == 0) {
            return false;
        }
        return this.allowMixed || arity <= 0 || numSourceTerminals <= 0 && numTargetTerminals <= 0;
    }

    public static void main(String[] argv) throws IOException {
        Scanner scanner = new Scanner(System.in, "utf-8");
        HierarchicalRuleExtractor extractor = new HierarchicalRuleExtractor();
        HieroLabeler labeler = null;
        if (argv.length > 0 && argv[0].equals("--hiero")) {
            labeler = new HieroLabeler(Vocabulary.id("X"));
        }
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] parts = FormatUtils.P_DELIM.split(line);
            if (parts.length < 3) continue;
            int[] source = Vocabulary.addAll(parts[0]);
            int[] target = Vocabulary.addAll(parts[1]);
            ArrayAlignment alignment = ArrayAlignment.fromString(parts[2], false);
            for (HierarchicalRule r : extractor.extract(source.length, target.length, alignment)) {
                if (labeler != null) {
                    System.out.println(r.toString(source, target, labeler, true));
                    continue;
                }
                System.out.println(r);
            }
        }
        scanner.close();
    }
}

