/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.extraction;

import edu.jhu.thrax.util.Vocabulary;
import java.util.HashMap;

public enum LabelCache {
    SLASH("/"),
    BACKSLASH("\\"),
    PLUS("+");

    private HashMap<Long, Integer> cache = new HashMap();
    private String glue;

    private LabelCache(String g) {
        this.glue = g;
    }

    public final int get(int left, int right) {
        long key = (long)left << 32 | (long)right & 0xFFFFFFFFL;
        Integer val = this.cache.get(key);
        if (val == null) {
            val = LabelCache.join(left, right, this.glue);
            this.cache.put(key, val);
        }
        return val;
    }

    private static final int join(int a, int b, String glue) {
        String word_a = Vocabulary.word(a);
        String word_b = Vocabulary.word(b);
        return Vocabulary.id(word_a.substring(0, word_a.length() - 1) + glue + word_b.substring(1));
    }
}

