/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.extraction;

import edu.jhu.thrax.extraction.SpanLabeler;

public class ManualSpanLabeler
implements SpanLabeler {
    private final int[] labels;
    private final int defaultLabel;
    private final int sentenceLength;

    public ManualSpanLabeler(int[] ls, int def) {
        this.labels = ls;
        this.defaultLabel = def;
        this.sentenceLength = ManualSpanLabeler.getSentenceLength(this.labels.length);
    }

    @Override
    public int getLabel(int from, int to) {
        int idx = ManualSpanLabeler.getLabelIndex(from, to, this.sentenceLength);
        if (idx >= this.labels.length || idx < 0) {
            return this.defaultLabel;
        }
        return this.labels[idx];
    }

    private static int getSentenceLength(int numLabels) {
        if (numLabels < 0) {
            return 0;
        }
        int result = 0;
        for (int triangle = 0; triangle != numLabels; triangle += ++result) {
        }
        return result;
    }

    private static int getLabelIndex(int from, int to, int length) {
        int result = 0;
        int offset = length;
        for (int i = 0; i < from; ++i) {
            result += offset;
            --offset;
        }
        int difference = to - from - 1;
        return result += difference;
    }
}

