/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.extraction;

import edu.jhu.thrax.extraction.LabelCache;
import edu.jhu.thrax.extraction.SpanLabeler;
import edu.jhu.thrax.syntax.ParseTree;
import edu.jhu.thrax.util.Vocabulary;
import java.util.List;

public class SAMTLabeler
implements SpanLabeler {
    private boolean allowConstituent = true;
    private boolean allowCCG = true;
    private boolean allowConcat = true;
    private boolean allowDoubleConcat = true;
    private UnaryCategoryHandler unaryCategoryHandler;
    private ParseTree tree;
    private int defaultLabel;

    public SAMTLabeler(String parse, boolean constituent, boolean ccg, boolean concat, boolean doubleConcat, String unary, int def) {
        this.allowConstituent = constituent;
        this.allowCCG = ccg;
        this.allowConcat = concat;
        this.allowDoubleConcat = doubleConcat;
        this.defaultLabel = def;
        this.unaryCategoryHandler = UnaryCategoryHandler.fromString(unary);
        this.tree = ParseTree.fromPennFormat(parse);
        if (this.tree == null) {
            System.err.printf("WARNING: SAMT labeler: %s is not a parse tree\n", parse);
        }
    }

    @Override
    public int getLabel(int from, int to) {
        int label;
        if (this.tree == null) {
            return this.defaultLabel;
        }
        if (this.allowConstituent && (label = this.constituentLabel(from, to)) != 0) {
            return label;
        }
        if (this.allowConcat && (label = this.concatenatedLabel(from, to)) != 0) {
            return label;
        }
        if (this.allowCCG) {
            label = this.forwardSlashLabel(from, to);
            if (label != 0) {
                return label;
            }
            label = this.backwardSlashLabel(from, to);
            if (label != 0) {
                return label;
            }
        }
        if (this.allowDoubleConcat && (label = this.doubleConcatenatedLabel(from, to)) != 0) {
            return label;
        }
        return this.defaultLabel;
    }

    private int constituentLabel(int from, int to) {
        List<ParseTree.Node> nodes = this.tree.internalNodesWithSpan(from, to);
        if (nodes.isEmpty()) {
            return 0;
        }
        switch (this.unaryCategoryHandler) {
            case TOP: {
                return nodes.get(0).label();
            }
            case BOTTOM: {
                return nodes.get(nodes.size() - 1).label();
            }
            case ALL: {
                String result = Vocabulary.word(nodes.get(0).label());
                for (int i = 1; i < nodes.size(); ++i) {
                    result = result + ":" + Vocabulary.word(nodes.get(i).label());
                }
                return Vocabulary.id(result);
            }
        }
        return 0;
    }

    private int concatenatedLabel(int from, int to) {
        for (int mid = from + 1; mid < to; ++mid) {
            int a = this.constituentLabel(from, mid);
            int b = this.constituentLabel(mid, to);
            if (a == 0 || b == 0) continue;
            return LabelCache.PLUS.get(a, b);
        }
        return 0;
    }

    private int forwardSlashLabel(int from, int to) {
        for (int end = to + 1; end <= this.tree.numLeaves(); ++end) {
            int a = this.constituentLabel(from, end);
            int b = this.constituentLabel(to, end);
            if (a == 0 || b == 0) continue;
            return LabelCache.SLASH.get(a, b);
        }
        return 0;
    }

    private int backwardSlashLabel(int from, int to) {
        for (int start = from - 1; start >= 0; --start) {
            int a = this.constituentLabel(start, to);
            int b = this.constituentLabel(start, from);
            if (a == 0 || b == 0) continue;
            return LabelCache.BACKSLASH.get(a, b);
        }
        return 0;
    }

    private int doubleConcatenatedLabel(int from, int to) {
        for (int mid1 = from + 1; mid1 < to - 1; ++mid1) {
            for (int mid2 = mid1 + 1; mid2 < to; ++mid2) {
                int a = this.constituentLabel(from, mid1);
                int b = this.constituentLabel(mid1, mid2);
                int c = this.constituentLabel(mid2, to);
                if (a == 0 || b == 0 || c == 0) continue;
                return LabelCache.PLUS.get(LabelCache.PLUS.get(a, b), c);
            }
        }
        return 0;
    }

    private static enum UnaryCategoryHandler {
        TOP,
        BOTTOM,
        ALL;


        public static UnaryCategoryHandler fromString(String s) {
            if (s.equalsIgnoreCase("top")) {
                return TOP;
            }
            if (s.equalsIgnoreCase("bottom")) {
                return BOTTOM;
            }
            return ALL;
        }
    }
}

