/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.comparators;

import java.io.IOException;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class FieldComparator {
    private final int fieldNumber;
    private final WritableComparator comparator;
    public int offset;

    public FieldComparator(int field, WritableComparator comparator) {
        if (field < 0) {
            throw new IllegalArgumentException("TextFieldComparator: cannot compare field of index " + field);
        }
        this.fieldNumber = field;
        this.comparator = comparator;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws IOException {
        int start1 = this.getFieldStart(this.fieldNumber, b1, s1);
        int start2 = this.getFieldStart(this.fieldNumber, b2, s2);
        int length1 = FieldComparator.getFieldLength(b1, start1);
        int length2 = FieldComparator.getFieldLength(b2, start2);
        return this.comparator.compare(b1, start1, length1, b2, start2, length2);
    }

    private final int getFieldStart(int field, byte[] bytes, int start) throws IOException {
        if (field == 0) {
            return start;
        }
        int fieldLength = FieldComparator.getFieldLength(bytes, start);
        return this.getFieldStart(field - 1, bytes, start + fieldLength);
    }

    private static final int getFieldLength(byte[] bytes, int start) throws IOException {
        int vint_size = WritableUtils.decodeVIntSize((byte)bytes[start]);
        int field_length = WritableComparator.readVInt((byte[])bytes, (int)start);
        return vint_size + field_length;
    }

    public int fieldEndIndex(byte[] bytes, int start) throws IOException {
        int fieldStart = this.getFieldStart(this.fieldNumber, bytes, start);
        int fieldLength = FieldComparator.getFieldLength(bytes, fieldStart);
        return fieldStart + fieldLength;
    }
}

