/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.comparators;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class TextMarginalComparator
extends WritableComparator {
    private static final Text.Comparator TEXT_COMPARATOR = new Text.Comparator();
    public static final Text MARGINAL = new Text("/MARGINAL/");
    private static final byte[] MARGINAL_BYTES = MARGINAL.getBytes();
    private static final int MARGINAL_LENGTH = MARGINAL.getLength();

    public TextMarginalComparator() {
        super(Text.class);
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int cmp = TEXT_COMPARATOR.compare(b1, s1, l1, b2, s2, l2);
        if (cmp == 0) {
            return 0;
        }
        int vIntSize = WritableUtils.decodeVIntSize((byte)b1[s1]);
        int cmpMarginal = TextMarginalComparator.compareBytes((byte[])b1, (int)(s1 + vIntSize), (int)(l1 - vIntSize), (byte[])MARGINAL_BYTES, (int)0, (int)MARGINAL_LENGTH);
        if (cmpMarginal == 0) {
            return -1;
        }
        vIntSize = WritableUtils.decodeVIntSize((byte)b2[s2]);
        cmpMarginal = TextMarginalComparator.compareBytes((byte[])b2, (int)(s2 + vIntSize), (int)(l2 - vIntSize), (byte[])MARGINAL_BYTES, (int)0, (int)MARGINAL_LENGTH);
        if (cmpMarginal == 0) {
            return 1;
        }
        return cmp;
    }
}

