/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import edu.jhu.thrax.hadoop.datatypes.AlignmentWritable;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.util.FormatUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Partitioner;

public class AlignedRuleWritable
implements WritableComparable<AlignedRuleWritable> {
    private RuleWritable rule;
    private AlignmentWritable alignment;

    public AlignedRuleWritable() {
        this.rule = null;
        this.alignment = null;
    }

    public AlignedRuleWritable(RuleWritable r, AlignmentWritable a) {
        this.rule = r;
        this.alignment = a;
    }

    public RuleWritable getRule() {
        return this.rule;
    }

    public AlignmentWritable getAlignment() {
        return this.alignment;
    }

    public void readFields(DataInput in) throws IOException {
        this.rule = new RuleWritable();
        this.alignment = new AlignmentWritable();
        this.rule.readFields(in);
        this.alignment.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.rule.write(out);
        this.alignment.write(out);
    }

    public boolean equals(Object o) {
        if (o instanceof AlignedRuleWritable) {
            return this.rule.equals(((AlignedRuleWritable)o).rule) && this.alignment.equals(((AlignedRuleWritable)o).alignment);
        }
        return false;
    }

    public int hashCode() {
        int result = 163;
        result = 37 * result + this.rule.hashCode();
        result = 37 * result + this.alignment.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rule.toString());
        sb.append(FormatUtils.DELIM);
        sb.append(this.alignment.toString());
        return sb.toString();
    }

    public int compareTo(AlignedRuleWritable that) {
        int cmp = this.rule.compareTo(that.rule);
        if (cmp != 0) {
            return cmp;
        }
        return this.alignment.compareTo(that.alignment);
    }

    static {
        WritableComparator.define(AlignedRuleWritable.class, (WritableComparator)new RuleYieldComparator());
    }

    public static class RuleYieldComparator
    extends WritableComparator {
        private static final WritableComparator RULE = new RuleWritable.YieldComparator();
        private static final WritableComparator ALIGNMENT = new AlignmentWritable.AlignmentComparator();

        public RuleYieldComparator() {
            super(AlignedRuleWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int cmp = RULE.compare(b1, s1, l1, b2, s2, l2);
                if (cmp != 0) {
                    return cmp;
                }
                int a1 = RuleWritable.size(b1, s1, l1);
                int a2 = RuleWritable.size(b2, s2, l2);
                return ALIGNMENT.compare(b1, s1 + a1, l1 - a1, b2, s2 + a2, l2 - a2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class RuleYieldPartitioner
    extends Partitioner<AlignedRuleWritable, Writable> {
        public int getPartition(AlignedRuleWritable key, Writable value, int num_partitions) {
            return (key.rule.hashCode() & Integer.MAX_VALUE) % num_partitions;
        }
    }
}

