/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import edu.jhu.thrax.hadoop.datatypes.AlignmentWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class Annotation
implements Writable {
    private AlignmentWritable f2e = null;
    private int count;

    public Annotation() {
        this.count = 0;
    }

    public Annotation(int c) {
        this.count = c;
    }

    public Annotation(Annotation a) {
        this.count = a.count;
        this.f2e = new AlignmentWritable(a.f2e);
    }

    public Annotation(AlignmentWritable f2e) {
        this.count = 1;
        this.f2e = f2e;
    }

    public void merge(Annotation that) {
        this.count += that.count;
    }

    public void readFields(DataInput in) throws IOException {
        boolean has_alignments = false;
        this.count = WritableUtils.readVInt((DataInput)in);
        if (this.count < 0) {
            this.count = -this.count;
            has_alignments = true;
        }
        if (has_alignments) {
            this.f2e = new AlignmentWritable();
            this.f2e.readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)(this.f2e != null ? -this.count : this.count));
        if (this.f2e != null) {
            this.f2e.write(out);
        }
    }

    public AlignmentWritable e2f() {
        return this.f2e.flip();
    }

    public AlignmentWritable f2e() {
        return this.f2e;
    }

    public void setAlignment(AlignmentWritable a) {
        this.f2e = a;
    }

    public int count() {
        return this.count;
    }
}

