/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.util.Vocabulary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class FeatureMap
implements Writable {
    private Map<Integer, Writable> map = new HashMap<Integer, Writable>();

    public FeatureMap() {
    }

    public FeatureMap(FeatureMap fm) {
        this();
        for (int key : fm.map.keySet()) {
            this.map.put(key, fm.map.get(key));
        }
    }

    public Writable get(int key) {
        return this.map.get(key);
    }

    public Writable get(String key) {
        return this.map.get(Vocabulary.id(key));
    }

    public void put(int key, Writable val) {
        this.map.put(key, val);
    }

    public void put(String key, Writable val) {
        this.map.put(Vocabulary.id(key), val);
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public Set<Integer> keySet() {
        return this.map.keySet();
    }

    public void readFields(DataInput in) throws IOException {
        this.map.clear();
        int size = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            int key = 0;
            Annotation val = null;
            key = WritableUtils.readVInt((DataInput)in);
            if (key == Vocabulary.id("Annotation")) {
                val = new Annotation();
                val.readFields(in);
            } else {
                val = new FloatWritable();
                val.readFields(in);
            }
            this.map.put(key, val);
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.map.size());
        for (int key : this.map.keySet()) {
            WritableUtils.writeVInt((DataOutput)out, (int)key);
            if (key == Vocabulary.id("Annotation")) {
                ((Annotation)this.get(key)).write(out);
                continue;
            }
            ((FloatWritable)this.get(key)).write(out);
        }
    }
}

