/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import edu.jhu.thrax.hadoop.datatypes.FeatureValue;
import edu.jhu.thrax.util.Vocabulary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class FeaturePair
implements Writable {
    public int key;
    public FeatureValue val;

    public FeaturePair() {
        this.key = 0;
        this.val = new FeatureValue();
    }

    public FeaturePair(int k, Writable v) {
        this.key = k;
        this.val = new FeatureValue(v);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.key);
        this.val.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.key = WritableUtils.readVInt((DataInput)in);
        this.val.readFields(in);
    }

    public int hashCode() {
        return this.key * 163 + ((Object)((Object)this.val)).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof FeaturePair) {
            FeaturePair that = (FeaturePair)o;
            return this.key == that.key && ((Object)((Object)this.val)).equals((Object)that.val);
        }
        return false;
    }

    public String toString() {
        return Vocabulary.word(this.key) + "=" + this.val.toString();
    }
}

