/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class IntPair
implements WritableComparable<IntPair> {
    public int fst;
    public int snd;

    public IntPair() {
    }

    public IntPair(int car, int cdr) {
        this.fst = car;
        this.snd = cdr;
    }

    public void reverse() {
        int tmp = this.fst;
        this.fst = this.snd;
        this.snd = tmp;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.fst);
        out.writeInt(this.snd);
    }

    public void readFields(DataInput in) throws IOException {
        this.fst = in.readInt();
        this.snd = in.readInt();
    }

    public int hashCode() {
        return this.fst * 163 + this.snd;
    }

    public boolean equals(Object o) {
        if (o instanceof IntPair) {
            IntPair ip = (IntPair)o;
            return this.fst == ip.fst && this.snd == ip.snd;
        }
        return false;
    }

    public String toString() {
        return this.fst + "\t" + this.snd;
    }

    public int compareTo(IntPair ip) {
        int cmp = ip.fst - this.fst;
        if (cmp != 0) {
            return cmp;
        }
        return ip.snd - this.snd;
    }

    static {
        WritableComparator.define(IntPair.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(IntPair.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int fst2;
            int fst1 = Comparator.readInt((byte[])b1, (int)s1);
            if (fst1 != (fst2 = Comparator.readInt((byte[])b2, (int)s2))) {
                return fst2 - fst1;
            }
            int snd1 = Comparator.readInt((byte[])b1, (int)(s1 + 4));
            int snd2 = Comparator.readInt((byte[])b2, (int)(s2 + 4));
            return snd2 - snd1;
        }
    }
}

