/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import edu.jhu.thrax.hadoop.comparators.FieldComparator;
import edu.jhu.thrax.hadoop.comparators.PrimitiveArrayMarginalComparator;
import edu.jhu.thrax.hadoop.datatypes.PrimitiveUtils;
import edu.jhu.thrax.util.FormatUtils;
import edu.jhu.thrax.util.Vocabulary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Partitioner;

public class RuleWritable
implements WritableComparable<RuleWritable> {
    public int lhs;
    public int[] source;
    public int[] target;
    public boolean monotone;

    public RuleWritable() {
        this.source = null;
        this.target = null;
    }

    @Deprecated
    public RuleWritable(String r) {
        String[] fields = FormatUtils.P_DELIM.split(r);
        this.lhs = Vocabulary.id(fields[0]);
        this.source = Vocabulary.addAll(fields[1]);
        this.target = Vocabulary.addAll(fields[2]);
        this.monotone = true;
    }

    public RuleWritable(RuleWritable r) {
        this.set(r);
    }

    public RuleWritable(int left, int[] src, int[] tgt, boolean m) {
        this.lhs = left;
        this.source = src;
        this.target = tgt;
        this.monotone = m;
    }

    public void set(RuleWritable r) {
        this.lhs = r.lhs;
        this.source = Arrays.copyOf(r.source, r.source.length);
        this.target = Arrays.copyOf(r.target, r.target.length);
        this.monotone = r.monotone;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.monotone);
        WritableUtils.writeVInt((DataOutput)out, (int)this.lhs);
        PrimitiveUtils.writeIntArray(out, this.source);
        PrimitiveUtils.writeIntArray(out, this.target);
    }

    public void readFields(DataInput in) throws IOException {
        this.monotone = in.readBoolean();
        this.lhs = WritableUtils.readVInt((DataInput)in);
        this.source = PrimitiveUtils.readIntArray(in);
        this.target = PrimitiveUtils.readIntArray(in);
    }

    public boolean sameYield(RuleWritable r) {
        return this.monotone == r.monotone && this.lhs == r.lhs && Arrays.equals(this.source, r.source) && Arrays.equals(this.target, r.target);
    }

    public boolean equals(Object o) {
        if (o instanceof RuleWritable) {
            return this.sameYield((RuleWritable)o);
        }
        return false;
    }

    public int hashCode() {
        int result = 163;
        result = 37 * result + this.lhs;
        result = 37 * result + (this.monotone ? 1 : 0);
        result = 37 * result + Arrays.hashCode(this.source);
        result = 37 * result + Arrays.hashCode(this.target);
        return result;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(Vocabulary.word(this.lhs));
        sb.append(FormatUtils.DELIM);
        int n = 1;
        for (i = 0; i < this.source.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            if (Vocabulary.nt(this.source[i])) {
                sb.append(FormatUtils.markup(Vocabulary.word(this.source[i]), n++));
                continue;
            }
            sb.append(Vocabulary.word(this.source[i]));
        }
        sb.append(FormatUtils.DELIM);
        n = this.monotone ? 1 : 2;
        for (i = 0; i < this.target.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            if (Vocabulary.nt(this.target[i])) {
                sb.append(FormatUtils.markup(Vocabulary.word(this.target[i]), this.monotone ? n++ : n--));
                continue;
            }
            sb.append(Vocabulary.word(this.target[i]));
        }
        return sb.toString();
    }

    public int compareTo(RuleWritable that) {
        int cmp = PrimitiveUtils.compareIntArrays(this.source, that.source);
        if (cmp != 0) {
            return cmp;
        }
        cmp = PrimitiveUtils.compare(this.lhs, that.lhs);
        if (cmp != 0) {
            return cmp;
        }
        cmp = PrimitiveUtils.compareIntArrays(this.target, that.target);
        if (cmp != 0) {
            return cmp;
        }
        cmp = PrimitiveUtils.compare(this.monotone, that.monotone);
        return cmp;
    }

    public static final int size(byte[] b, int s, int l) throws IOException {
        int pos = s;
        int srclen_size = WritableUtils.decodeVIntSize((byte)b[pos += WritableUtils.decodeVIntSize((byte)b[s + 1]) + 1]);
        int source_size = WritableComparator.readVInt((byte[])b, (int)pos);
        int tgtlen_size = WritableUtils.decodeVIntSize((byte)b[pos += srclen_size + source_size]);
        int target_size = WritableComparator.readVInt((byte[])b, (int)pos);
        return (pos += tgtlen_size + target_size) - s;
    }

    static {
        WritableComparator.define(RuleWritable.class, (WritableComparator)new YieldComparator());
    }

    public static class TargetPartitioner
    extends Partitioner<RuleWritable, Writable> {
        public int getPartition(RuleWritable key, Writable value, int numPartitions) {
            return (Arrays.hashCode(key.target) & Integer.MAX_VALUE) % numPartitions;
        }
    }

    public static class SourcePartitioner
    extends Partitioner<RuleWritable, Writable> {
        public int getPartition(RuleWritable key, Writable value, int numPartitions) {
            return (Arrays.hashCode(key.source) & Integer.MAX_VALUE) % numPartitions;
        }
    }

    public static class LHSPartitioner
    extends Partitioner<RuleWritable, Writable> {
        public int getPartition(RuleWritable key, Writable value, int numPartitions) {
            return (key.lhs & Integer.MAX_VALUE) % numPartitions;
        }
    }

    public static class YieldComparator
    extends WritableComparator {
        private static final WritableComparator PARRAY_COMP = new PrimitiveArrayMarginalComparator();
        private static final FieldComparator SOURCE_COMP = new FieldComparator(0, PARRAY_COMP);
        private static final FieldComparator TARGET_COMP = new FieldComparator(1, PARRAY_COMP);

        public YieldComparator() {
            super(RuleWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int lhs2;
                int h1 = WritableUtils.decodeVIntSize((byte)b1[s1 + 1]) + 1;
                int h2 = WritableUtils.decodeVIntSize((byte)b2[s2 + 1]) + 1;
                int cmp = SOURCE_COMP.compare(b1, s1 + h1, l1 - h1, b2, s2 + h2, l2 - h2);
                if (cmp != 0) {
                    return cmp;
                }
                int lhs1 = WritableComparator.readVInt((byte[])b1, (int)(s1 + 1));
                cmp = PrimitiveUtils.compare(lhs1, lhs2 = WritableComparator.readVInt((byte[])b2, (int)(s2 + 1)));
                if (cmp != 0) {
                    return cmp;
                }
                cmp = TARGET_COMP.compare(b1, s1 + h1, l1 - h1, b2, s2 + h2, l2 - h2);
                if (cmp != 0) {
                    return cmp;
                }
                return PrimitiveUtils.compare(b1[s1], b2[s2]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class FirstWordPartitioner
    extends Partitioner<RuleWritable, Writable> {
        public int getPartition(RuleWritable key, Writable value, int numPartitions) {
            if (key.source.length == 0) {
                return 0;
            }
            return (key.source[0] & Integer.MAX_VALUE) % numPartitions;
        }
    }

    public static class YieldPartitioner
    extends Partitioner<RuleWritable, Writable> {
        public int getPartition(RuleWritable key, Writable value, int numPartitions) {
            return (key.hashCode() & Integer.MAX_VALUE) % numPartitions;
        }
    }
}

