/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.datatypes;

import edu.jhu.thrax.hadoop.comparators.TextMarginalComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class TextPair
implements WritableComparable<TextPair> {
    public Text fst;
    public Text snd;

    public TextPair() {
        this.fst = new Text();
        this.snd = new Text();
    }

    public TextPair(Text car, Text cdr) {
        this.fst = car;
        this.snd = cdr;
    }

    public void reverse() {
        Text tmp = this.fst;
        this.fst = this.snd;
        this.snd = tmp;
    }

    public void write(DataOutput out) throws IOException {
        this.fst.write(out);
        this.snd.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.fst.readFields(in);
        this.snd.readFields(in);
    }

    public int hashCode() {
        return this.fst.hashCode() * 163 + this.snd.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TextPair) {
            TextPair tp = (TextPair)o;
            return this.fst.equals((Object)tp.fst) && this.snd.equals((Object)tp.snd);
        }
        return false;
    }

    public String toString() {
        return this.fst.toString() + "\t" + this.snd.toString();
    }

    public int compareTo(TextPair tp) {
        int cmp = this.fst.compareTo((BinaryComparable)tp.fst);
        if (cmp != 0) {
            return cmp;
        }
        return this.snd.compareTo((BinaryComparable)tp.snd);
    }

    static {
        WritableComparator.define(TextPair.class, (WritableComparator)new Comparator());
    }

    public static class SndMarginalComparator
    extends WritableComparator {
        private static final Text.Comparator TEXT_COMPARATOR = new Text.Comparator();
        private static final TextMarginalComparator MARGINAL_COMPARATOR = new TextMarginalComparator();

        public SndMarginalComparator() {
            super(TextPair.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int length1 = WritableUtils.decodeVIntSize((byte)b1[s1]) + SndMarginalComparator.readVInt((byte[])b1, (int)s1);
                int length2 = WritableUtils.decodeVIntSize((byte)b2[s2]) + SndMarginalComparator.readVInt((byte[])b2, (int)s2);
                int cmp = TEXT_COMPARATOR.compare(b1, s1, length1, b2, s2, length2);
                if (cmp != 0) {
                    return cmp;
                }
                return MARGINAL_COMPARATOR.compare(b1, s1 + length1, l1 - length1, b2, s2 + length2, l2 - length2);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public static class FstMarginalComparator
    extends WritableComparator {
        private static final Text.Comparator TEXT_COMPARATOR = new Text.Comparator();
        private static final TextMarginalComparator MARGINAL_COMPARATOR = new TextMarginalComparator();

        public FstMarginalComparator() {
            super(TextPair.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int vis1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
                int vi1 = FstMarginalComparator.readVInt((byte[])b1, (int)s1);
                int vis2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
                int vi2 = FstMarginalComparator.readVInt((byte[])b2, (int)s2);
                int length1 = vis1 + vi1;
                int length2 = vis2 + vi2;
                int cmp = TEXT_COMPARATOR.compare(b1, s1 + length1, l1 - length1, b2, s2 + length2, l2 - length2);
                if (cmp != 0) {
                    return cmp;
                }
                return MARGINAL_COMPARATOR.compare(b1, s1, length1, b2, s2, length2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class Comparator
    extends WritableComparator {
        private static final Text.Comparator TEXT_COMPARATOR = new Text.Comparator();

        public Comparator() {
            super(TextPair.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int length1 = WritableUtils.decodeVIntSize((byte)b1[s1]) + Comparator.readVInt((byte[])b1, (int)s1);
                int length2 = WritableUtils.decodeVIntSize((byte)b2[s2]) + Comparator.readVInt((byte[])b2, (int)s2);
                int cmp = TEXT_COMPARATOR.compare(b1, s1, length1, b2, s2, length2);
                if (cmp != 0) {
                    return cmp;
                }
                return TEXT_COMPARATOR.compare(b1, s1 + length1, l1 - length1, b2, s2 + length2, l2 - length2);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

