/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.distributional;

import edu.jhu.jerboa.sim.SLSH;
import edu.jhu.jerboa.sim.Signature;
import edu.jhu.thrax.hadoop.datatypes.PrimitiveUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ContextWritable
implements Writable {
    public IntWritable strength;
    public BooleanWritable compacted;
    public MapWritable map;
    public float[] sums;

    public ContextWritable() {
        this(false);
    }

    public ContextWritable(boolean compacted) {
        this.strength = new IntWritable(0);
        this.compacted = new BooleanWritable(compacted);
        if (compacted) {
            this.map = null;
            this.sums = null;
        } else {
            this.map = new MapWritable();
            this.sums = null;
        }
    }

    public ContextWritable(int strength, MapWritable map) {
        this.strength = new IntWritable(strength);
        this.compacted = new BooleanWritable(false);
        this.map = new MapWritable(map);
        this.sums = null;
    }

    public ContextWritable(int strength, float[] sums) {
        this.strength = new IntWritable(strength);
        this.compacted = new BooleanWritable(true);
        this.map = null;
        this.sums = sums;
    }

    public void merge(ContextWritable that, SLSH slsh) {
        if (this.compacted.get()) {
            if (!that.compacted.get()) {
                that.compact(slsh);
            }
            this.mergeSums(that, slsh);
        } else if (that.compacted.get()) {
            this.compact(slsh);
            this.mergeSums(that, slsh);
        } else {
            for (Writable feature_text : that.map.keySet()) {
                int feature_value = ((IntWritable)that.map.get((Object)feature_text)).get();
                IntWritable current_value = (IntWritable)this.map.get((Object)feature_text);
                if (current_value != null) {
                    this.map.put(feature_text, (Writable)new IntWritable(current_value.get() + feature_value));
                    continue;
                }
                this.map.put(feature_text, (Writable)new IntWritable(feature_value));
            }
        }
        this.strength = new IntWritable(this.strength.get() + that.strength.get());
    }

    private void mergeSums(ContextWritable that, SLSH slsh) {
        if (!that.compacted.get()) {
            throw new RuntimeException("Trying to merge sums on un-compacted ContextWritable.");
        }
        Signature this_signature = new Signature();
        Signature that_signature = new Signature();
        this_signature.sums = this.sums;
        that_signature.sums = this.sums;
        slsh.updateSignature(this_signature, that_signature);
    }

    public void compact(SLSH slsh) {
        Signature signature = new Signature();
        slsh.initializeSignature(signature);
        for (Writable feature_name : this.map.keySet()) {
            slsh.updateSignature(signature, ((Text)feature_name).toString(), (double)((IntWritable)this.map.get((Object)feature_name)).get(), 1);
        }
        this.compacted.set(true);
        this.map = null;
        this.sums = signature.sums;
    }

    public void readFields(DataInput in) throws IOException {
        this.strength.readFields(in);
        this.compacted.readFields(in);
        if (this.compacted.get()) {
            this.map = null;
            this.sums = PrimitiveUtils.readFloatArray(in);
        } else {
            if (this.map == null) {
                this.map = new MapWritable();
            }
            this.map.readFields(in);
            this.sums = null;
        }
    }

    public void write(DataOutput out) throws IOException {
        this.strength.write(out);
        this.compacted.write(out);
        if (this.compacted.get()) {
            PrimitiveUtils.writeFloatArray(out, this.sums);
        } else {
            this.map.write(out);
        }
    }
}

