/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.distributional;

import edu.jhu.jerboa.sim.SLSH;
import edu.jhu.thrax.hadoop.distributional.CommonLSH;
import edu.jhu.thrax.hadoop.distributional.ContextWritable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DistributionalContextCombiner
extends Reducer<Text, ContextWritable, Text, ContextWritable> {
    private SLSH slsh;

    public void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.slsh = CommonLSH.getSLSH(conf);
    }

    protected void reduce(Text key, Iterable<ContextWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        ContextWritable combined = new ContextWritable();
        for (ContextWritable input : values) {
            combined.merge(input, this.slsh);
        }
        if (!combined.compacted.get()) {
            combined.compact(this.slsh);
        }
        context.write((Object)key, (Object)combined);
    }
}

