/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.distributional;

import edu.jhu.thrax.distributional.ContextPhrase;
import edu.jhu.thrax.distributional.ContextPhraseExtractor;
import edu.jhu.thrax.hadoop.distributional.ContextWritable;
import edu.jhu.thrax.util.MalformedInput;
import edu.jhu.thrax.util.exceptions.EmptySentenceException;
import edu.jhu.thrax.util.exceptions.MalformedInputException;
import edu.jhu.thrax.util.exceptions.MalformedParseException;
import edu.jhu.thrax.util.exceptions.NotEnoughFieldsException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DistributionalContextMapper
extends Mapper<LongWritable, Text, Text, ContextWritable> {
    private ContextPhraseExtractor extractor;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.extractor = new ContextPhraseExtractor(conf);
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.extractor == null) {
            return;
        }
        String line = value.toString();
        try {
            List<ContextPhrase> phrases = this.extractor.extract(line);
            for (ContextPhrase cp : phrases) {
                context.write((Object)cp.getPhrase(), (Object)new ContextWritable(1, cp.getFeatures()));
            }
        }
        catch (NotEnoughFieldsException e) {
            context.getCounter((Enum)MalformedInput.NOT_ENOUGH_FIELDS).increment(1L);
        }
        catch (EmptySentenceException e) {
            context.getCounter((Enum)MalformedInput.EMPTY_SENTENCE).increment(1L);
        }
        catch (MalformedParseException e) {
            context.getCounter((Enum)MalformedInput.MALFORMED_PARSE).increment(1L);
        }
        catch (MalformedInputException e) {
            context.getCounter((Enum)MalformedInput.UNKNOWN).increment(1L);
        }
    }
}

