/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.distributional;

import edu.jhu.jerboa.sim.SLSH;
import edu.jhu.jerboa.sim.Signature;
import edu.jhu.thrax.hadoop.distributional.CommonLSH;
import edu.jhu.thrax.hadoop.distributional.ContextWritable;
import edu.jhu.thrax.hadoop.distributional.SignatureWritable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DistributionalContextReducer
extends Reducer<Text, ContextWritable, SignatureWritable, NullWritable> {
    private int minCount;
    private SLSH slsh;

    public void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.minCount = conf.getInt("thrax.min-phrase-count", 3);
        this.slsh = CommonLSH.getSLSH(conf);
    }

    protected void reduce(Text key, Iterable<ContextWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        ContextWritable reduced = new ContextWritable();
        for (ContextWritable input : values) {
            reduced.merge(input, this.slsh);
        }
        if (!reduced.compacted.get()) {
            reduced.compact(this.slsh);
        }
        if (reduced.strength.get() >= this.minCount) {
            Signature reduced_signature = new Signature();
            reduced_signature.sums = reduced.sums;
            this.slsh.buildSignature(reduced_signature, false);
            context.write((Object)new SignatureWritable(key, reduced_signature, reduced.strength.get()), (Object)NullWritable.get());
        }
    }
}

