/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.distributional;

import edu.jhu.jerboa.sim.Signature;
import edu.jhu.thrax.hadoop.datatypes.PrimitiveUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Partitioner;

public class SignatureWritable
implements WritableComparable<SignatureWritable> {
    public Text key;
    public byte[] bytes;
    public IntWritable strength;

    public SignatureWritable() {
        this.key = new Text();
        this.bytes = null;
        this.strength = new IntWritable();
    }

    public SignatureWritable(Text key, Signature signature, int strength) {
        this.key = new Text(key);
        this.bytes = signature.bytes;
        this.strength = new IntWritable(strength);
    }

    public void readFields(DataInput in) throws IOException {
        this.key.readFields(in);
        this.bytes = PrimitiveUtils.readByteArray(in);
        this.strength.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.key.write(out);
        PrimitiveUtils.writeByteArray(out, this.bytes);
        this.strength.write(out);
    }

    public int compareTo(SignatureWritable that) {
        int cmp = this.strength.compareTo((Object)that.strength);
        if (cmp != 0) {
            return -cmp;
        }
        return this.key.compareTo((BinaryComparable)that.key);
    }

    public static class SignaturePartitioner
    extends Partitioner<SignatureWritable, Writable> {
        public int getPartition(SignatureWritable signature, Writable value, int num_partitions) {
            int hash = 163;
            hash = 37 * hash + signature.key.hashCode();
            hash = 37 * hash + signature.bytes.hashCode();
            hash = 37 * hash + signature.strength.hashCode();
            return (hash & Integer.MAX_VALUE) % num_partitions;
        }
    }
}

