/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.extraction;

import edu.jhu.thrax.hadoop.datatypes.AlignedRuleWritable;
import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.extraction.AnnotatedRule;
import edu.jhu.thrax.hadoop.extraction.RuleWritableExtractor;
import edu.jhu.thrax.hadoop.extraction.RuleWritableExtractorFactory;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ExtractionMapper
extends Mapper<LongWritable, Text, AlignedRuleWritable, Annotation> {
    private RuleWritableExtractor extractor;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
        Vocabulary.initialize(conf, vocabulary_path);
        this.extractor = RuleWritableExtractorFactory.create(context);
        if (this.extractor == null) {
            System.err.println("WARNING: could not create rule extractor as configured!");
        }
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.extractor == null) {
            return;
        }
        for (AnnotatedRule ar : this.extractor.extract(value)) {
            context.write((Object)new AlignedRuleWritable(ar.rule, ar.f2e), (Object)ar.annotation);
        }
        context.progress();
    }
}

