/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.extraction;

import edu.jhu.thrax.hadoop.datatypes.AlignedRuleWritable;
import edu.jhu.thrax.hadoop.datatypes.AlignmentWritable;
import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;

public class ExtractionReducer
extends Reducer<AlignedRuleWritable, Annotation, RuleWritable, Annotation> {
    private RuleWritable currentRule = null;
    private Annotation currentAnnotation = null;
    private AlignmentWritable maxAlignment = null;
    private int alignmentCount;
    private int minCount;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
        Vocabulary.initialize(conf, vocabulary_path);
        this.minCount = conf.getInt("thrax.min-rule-count", 1);
    }

    protected void reduce(AlignedRuleWritable key, Iterable<Annotation> values, Reducer.Context context) throws IOException, InterruptedException {
        RuleWritable rule = key.getRule();
        AlignmentWritable alignment = key.getAlignment();
        Annotation merged = new Annotation();
        for (Annotation a : values) {
            merged.merge(a);
        }
        if (!rule.equals(this.currentRule)) {
            if (this.currentRule != null && (this.currentAnnotation.count() >= this.minCount || ExtractionReducer.isUnigramRule(this.currentRule))) {
                this.currentAnnotation.setAlignment(this.maxAlignment);
                context.write((Object)this.currentRule, (Object)this.currentAnnotation);
                context.progress();
            }
            this.currentRule = new RuleWritable(rule);
            this.currentAnnotation = new Annotation();
            this.alignmentCount = 0;
            this.maxAlignment = null;
        }
        this.currentAnnotation.merge(merged);
        if (this.alignmentCount < merged.count()) {
            this.maxAlignment = new AlignmentWritable(alignment);
            this.alignmentCount = merged.count();
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        if (this.currentRule != null && (this.currentAnnotation.count() >= this.minCount || ExtractionReducer.isUnigramRule(this.currentRule))) {
            this.currentAnnotation.setAlignment(this.maxAlignment);
            context.write((Object)this.currentRule, (Object)this.currentAnnotation);
            context.progress();
        }
    }

    private static boolean isUnigramRule(RuleWritable rule) {
        if (rule.source.length == 1) {
            return !Vocabulary.nt(rule.source[0]);
        }
        return rule.target.length == 1 && !Vocabulary.nt(rule.target[0]);
    }
}

