/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class AdjacentNonTerminalsFeature
implements SimpleFeature {
    public static final String NAME = "adjacent";
    public static final String LABEL = "Adjacent";
    private static final IntWritable ZERO = new IntWritable(0);
    private static final IntWritable ONE = new IntWritable(1);

    @Override
    public Writable score(RuleWritable r) {
        for (int i = 0; i < r.source.length - 1; ++i) {
            if (!Vocabulary.nt(r.source[i])) continue;
            if (Vocabulary.nt(r.source[i + 1])) {
                return ONE;
            }
            i += 2;
        }
        return ZERO;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ONE);
    }
}

