/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;

public class CharacterCompressionRatioFeature
implements SimpleFeature {
    private static final FloatWritable ZERO = new FloatWritable(0.0f);
    public static final String NAME = "char-cr";
    public static final String LABEL = "CharLogCR";

    @Override
    public Writable score(RuleWritable r) {
        int src_length = 0;
        for (int tok : r.source) {
            if (Vocabulary.nt(tok)) continue;
            src_length += Vocabulary.word(tok).length();
        }
        src_length += r.source.length - 1;
        int tgt_length = 0;
        for (int tok : r.target) {
            if (Vocabulary.nt(tok)) continue;
            tgt_length += Vocabulary.word(tok).length();
        }
        if (src_length == 0 || (tgt_length += r.target.length - 1) == 0) {
            return ZERO;
        }
        return new FloatWritable((float)Math.log((float)tgt_length / (float)src_length));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }
}

