/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.features.AbstractnessFeature;
import edu.jhu.thrax.hadoop.features.AdjacentNonTerminalsFeature;
import edu.jhu.thrax.hadoop.features.CharacterCompressionRatioFeature;
import edu.jhu.thrax.hadoop.features.CharacterCountDifferenceFeature;
import edu.jhu.thrax.hadoop.features.ConsumeSourceTerminalsFeature;
import edu.jhu.thrax.hadoop.features.GlueRuleFeature;
import edu.jhu.thrax.hadoop.features.IdentityFeature;
import edu.jhu.thrax.hadoop.features.LexicalityFeature;
import edu.jhu.thrax.hadoop.features.MonotonicFeature;
import edu.jhu.thrax.hadoop.features.PhrasePenaltyFeature;
import edu.jhu.thrax.hadoop.features.ProduceTargetTerminalsFeature;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.hadoop.features.SourceWordCounterFeature;
import edu.jhu.thrax.hadoop.features.TargetWordCounterFeature;
import edu.jhu.thrax.hadoop.features.WordCompressionRatioFeature;
import edu.jhu.thrax.hadoop.features.WordCountDifferenceFeature;
import edu.jhu.thrax.hadoop.features.WordLengthDifferenceFeature;
import edu.jhu.thrax.hadoop.features.XRuleFeature;
import edu.jhu.thrax.util.FormatUtils;
import java.util.ArrayList;
import java.util.List;

public class SimpleFeatureFactory {
    public static SimpleFeature get(String name) {
        if (name.equals("abstract")) {
            return new AbstractnessFeature();
        }
        if (name.equals("adjacent")) {
            return new AdjacentNonTerminalsFeature();
        }
        if (name.equals("lexical")) {
            return new LexicalityFeature();
        }
        if (name.equals("x-rule")) {
            return new XRuleFeature();
        }
        if (name.equals("monotonic")) {
            return new MonotonicFeature();
        }
        if (name.equals("phrase-penalty")) {
            return new PhrasePenaltyFeature();
        }
        if (name.equals("source-word-count")) {
            return new SourceWordCounterFeature();
        }
        if (name.equals("target-word-count")) {
            return new TargetWordCounterFeature();
        }
        if (name.equals("source-terminals-without-target")) {
            return new ConsumeSourceTerminalsFeature();
        }
        if (name.equals("target-terminals-without-source")) {
            return new ProduceTargetTerminalsFeature();
        }
        if (name.equals("identity")) {
            return new IdentityFeature();
        }
        if (name.equals("word-count-difference")) {
            return new WordCountDifferenceFeature();
        }
        if (name.equals("word-length-difference")) {
            return new WordLengthDifferenceFeature();
        }
        if (name.equals("word-cr")) {
            return new WordCompressionRatioFeature();
        }
        if (name.equals("char-count-difference")) {
            return new CharacterCountDifferenceFeature();
        }
        if (name.equals("char-cr")) {
            return new CharacterCompressionRatioFeature();
        }
        if (name.equals("glue-rule")) {
            return new GlueRuleFeature();
        }
        return null;
    }

    public static List<SimpleFeature> getAll(String names) {
        String[] feature_names = FormatUtils.P_COMMA_OR_SPACE.split(names);
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (String feature_name : feature_names) {
            SimpleFeature feature = SimpleFeatureFactory.get(feature_name);
            if (feature == null) continue;
            features.add(feature);
        }
        return features;
    }
}

